/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.mobchip.bukkit.BukkitBrain;
import be.isach.ultracosmetics.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public class MountSnake
extends Mount {
    private final List<Creature> tail = new ArrayList<Creature>();
    private int color = 1;

    public MountSnake(UltraPlayer owner, MountType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void setupEntity() {
        this.color = MathUtils.randomRangeInt(0, 14);
        Sheep sheep = (Sheep)this.entity;
        sheep.setNoDamageTicks(Integer.MAX_VALUE);
        sheep.setColor(DyeColor.values()[this.color]);
        this.tail.add((Creature)sheep);
        this.addSheepToTail(4);
    }

    @Override
    public void onClear() {
        super.onClear();
        for (Entity entity : this.tail) {
            entity.remove();
        }
        this.tail.clear();
    }

    @Override
    public void onUpdate() {
        if (this.getPlayer() == null) {
            return;
        }
        Vector vel = this.getPlayer().getLocation().getDirection().setY(0).normalize().multiply(16);
        Creature before = null;
        for (int i = 0; i < this.tail.size(); ++i) {
            Location loc;
            Creature tailEnt = this.tail.get(i);
            if (before == null) {
                loc = tailEnt.getLocation().add(vel);
            } else {
                loc = before.getLocation();
                Location tp = before.getLocation().add(this.traj((Entity)before, (Entity)tailEnt).multiply(1.4));
                tp.setPitch(tailEnt.getLocation().getPitch());
                tp.setYaw(tailEnt.getLocation().getYaw());
                this.getUltraCosmetics().getScheduler().teleportAsync((Entity)tailEnt, tp);
            }
            BukkitBrain.getBrain((Mob)tailEnt).getController().moveTo(loc);
            before = tailEnt;
        }
    }

    public Vector traj(Location a, Location b) {
        return b.toVector().subtract(a.toVector()).setY(0).normalize();
    }

    public Vector traj(Entity a, Entity b) {
        return this.traj(a.getLocation(), b.getLocation());
    }

    public void addSheepToTail(int amount) {
        Player player = this.getPlayer();
        for (int i = 0; i < amount; ++i) {
            Location loc = player.getLocation();
            if (!this.tail.isEmpty()) {
                loc = this.lastTail().getLocation();
            }
            if (this.tail.size() > 1) {
                loc.add(this.traj((Entity)this.tail.get(this.tail.size() - 2), (Entity)this.lastTail()));
            } else {
                loc.subtract(player.getLocation().getDirection().setY(0));
            }
            Sheep tailEnt = (Sheep)loc.getWorld().spawn(loc, Sheep.class);
            tailEnt.setNoDamageTicks(Integer.MAX_VALUE);
            tailEnt.setRemoveWhenFarAway(false);
            this.tail.add((Creature)tailEnt);
            tailEnt.setColor(DyeColor.values()[this.color]);
            tailEnt.setPersistent(false);
        }
    }

    @EventHandler
    public void onSnakeDamage(EntityDamageEvent event) {
        if (this.tail.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    private Creature lastTail() {
        return this.tail.get(this.tail.size() - 1);
    }
}

