/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.particleeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ParticleEffectFrostLord
extends ParticleEffect {
    private final XSound.SoundPlayer sound;
    private final ParticleDisplay secondaryDisplay;
    private int step = 0;
    private float stepY = 0.0f;
    private float radius = 1.5f;

    public ParticleEffectFrostLord(UltraPlayer owner, ParticleEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.useAlternativeEffect = true;
        this.sound = XSound.BLOCK_SNOW_BREAK.record().withVolume(0.5f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
        this.secondaryDisplay = ParticleDisplay.of((XParticle)((ParticleEffectType)this.getType()).getEffect()).withCount(this.getModifiedAmount(48)).withExtra(0.3);
    }

    @Override
    public void onUpdate() {
        for (int i = 0; i < 6; ++i) {
            Location location = this.getPlayer().getLocation();
            double inc = 0.06283185307179587;
            double angle = (double)this.step * inc + (double)this.stepY + (double)i;
            Vector v = new Vector();
            v.setX(Math.cos(angle) * (double)this.radius);
            v.setZ(Math.sin(angle) * (double)this.radius);
            this.display.spawn(location.clone().add(v).add(0.0, (double)this.stepY, 0.0));
            if (this.stepY < 3.0f) {
                this.radius -= 0.022f;
                this.stepY += 0.045f;
                continue;
            }
            this.stepY = 0.0f;
            this.step = 0;
            this.radius = 1.5f;
            this.sound.play();
            this.secondaryDisplay.spawn(location.clone().add(0.0, 3.0, 0.0));
        }
    }
}

