/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.particleeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ColorUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleEffectRainbowWings
extends ParticleEffect {
    private static final boolean x = true;
    private static final boolean o = false;
    private static final boolean[][] shape = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, false, false}, {false, false, true, true, true, true, true, false, false, false, true, true, true, true, true, false, false, false}, {false, false, false, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false}, {false, false, false, false, true, true, true, true, true, true, true, true, true, false, false, false, false, false}, {false, false, false, false, true, true, true, true, false, true, true, true, true, false, false, false, false, false}, {false, false, false, false, false, true, true, true, false, true, true, true, false, false, false, false, false, false}, {false, false, false, false, false, true, true, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, true, true, false, false, false, false, false}};

    public ParticleEffectRainbowWings(UltraPlayer owner, ParticleEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.useAlternativeEffect = true;
    }

    @Override
    public void onUpdate() {
        this.drawParticles(this.getPlayer().getLocation());
    }

    @Override
    public void showAlternativeEffect() {
        this.alternativeEffect.withColor(ColorUtils.getRainbowColor()).spawn();
    }

    private void drawParticles(Location location) {
        double defX;
        this.display.withColor(ColorUtils.getRainbowColor());
        double space = 0.2;
        double x = defX = location.getX() - space * (double)shape[0].length / 2.0 + space;
        double y = location.clone().getY() + 2.0;
        double angle = -((location.getYaw() + 180.0f) / 60.0f);
        angle += location.getYaw() < -180.0f ? 3.25 : 2.985;
        boolean[][] blArray = shape;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean[] row;
            for (boolean pixel : row = blArray[i]) {
                if (pixel) {
                    Location target = location.clone();
                    target.setX(x);
                    target.setY(y);
                    Vector v = target.toVector().subtract(location.toVector());
                    v = ParticleEffectRainbowWings.rotateAroundAxisY(v, angle);
                    Vector v2 = ParticleEffectRainbowWings.getBackVector(location);
                    v2.setY(0).multiply(-0.2);
                    location.add(v);
                    location.add(v2);
                    this.display.spawn(location);
                    location.subtract(v2);
                    location.subtract(v);
                }
                x += space;
            }
            y -= space;
            x = defX;
        }
    }

    private static Vector rotateAroundAxisY(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    private static Vector getBackVector(Location loc) {
        double rads = Math.toRadians(loc.getYaw() + 90.0f);
        return new Vector(Math.cos(rads), 0.0, Math.sin(rads));
    }
}

