/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.particleeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class ParticleEffectSuperHero
extends ParticleEffect {
    private final boolean x = true;
    private final ParticleDisplay secondary;
    private final boolean[][] shape = new boolean[][]{{true, true, true, true, true}, {true, true, true, true, true}, {true, true, true, true, true}, {true, true, true, true, true}, {true, true, true, true, true}, {true, true, true, true, true}, {true, true, true, true, true}, {true, true, true, true, true}};

    public ParticleEffectSuperHero(UltraPlayer owner, ParticleEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.display.withColor(Color.RED).withCount(this.getModifiedAmount(3));
        this.secondary = ParticleDisplay.of((XParticle)XParticle.CLOUD).offset(0.15, 0.1, 0.15).withEntity((Entity)this.getPlayer()).withCount(this.getModifiedAmount(4));
    }

    @Override
    public void onUpdate() {
        this.drawParticles(this.getPlayer().getLocation());
        this.secondary.spawn();
    }

    private void drawParticles(Location location) {
        double defY;
        double defX;
        double space = 0.2;
        double x = defX = location.getX() - space * (double)this.shape[0].length / 2.0 + space / 2.0;
        double y = defY = location.getY() + 1.5;
        double angle = -((location.getYaw() + 180.0f) / 60.0f);
        angle += location.getYaw() < -180.0f ? 3.25 : 2.985;
        for (int i = 0; i < this.shape.length; ++i) {
            for (int j = 0; j < this.shape[i].length; ++j) {
                if (this.shape[i][j]) {
                    Location target = location.clone();
                    target.setX(x);
                    target.setY(y);
                    Vector v = target.toVector().subtract(location.toVector());
                    Vector v2 = ParticleEffectSuperHero.getBackVector(location);
                    v = ParticleEffectSuperHero.rotateAroundAxisY(v, angle);
                    double iT = (double)i / 10.0;
                    v2.setY(0).multiply(-0.2 - iT);
                    Location loc = location.clone();
                    loc.add(v);
                    loc.add(v2);
                    if (this.isMoving()) {
                        loc.setY(defY);
                    }
                    this.display.spawn(loc);
                    loc.subtract(v2);
                    loc.subtract(v);
                }
                x += space;
            }
            y -= space;
            x = defX;
        }
    }

    public static Vector rotateAroundAxisY(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    public static final Vector rotateAroundAxisX(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.getY() * cos - v.getZ() * sin;
        double z = v.getY() * sin + v.getZ() * cos;
        return v.setY(y).setZ(z);
    }

    public static final Vector rotateAroundAxisZ(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos - v.getY() * sin;
        double y = v.getX() * sin + v.getY() * cos;
        return v.setX(x).setY(y);
    }

    private static Vector getBackVector(Location loc) {
        double rads = Math.toRadians(loc.getYaw() + 90.0f);
        return new Vector(Math.cos(rads), 0.0, Math.sin(rads));
    }
}

