/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.pets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.EntityCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.TextComponent;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.NamedTextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import be.isach.ultracosmetics.shaded.mobchip.EntityBrain;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.PathfinderLookAtEntity;
import be.isach.ultracosmetics.shaded.mobchip.bukkit.BukkitBrain;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.PetPathfinder;
import com.cryptomorin.xseries.XAttribute;
import com.cryptomorin.xseries.XEntityType;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Difficulty;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Pet
extends EntityCosmetic<PetType, Mob>
implements Updatable {
    private static final Attribute FLYING_SPEED = (Attribute)XAttribute.FLYING_SPEED.get();
    private final ParticleDisplay AIRLIFT_POOF = ParticleDisplay.of((XParticle)XParticle.POOF).withCount(10).offset(0.5, 0.5, 0.5);
    private final boolean canRide = SettingsManager.getConfig().getBoolean("Pets-Can-Ride", false);
    protected final boolean showName = SettingsManager.getConfig().getBoolean("Show-Pets-Names", true);
    protected List<Item> items = new ArrayList<Item>();
    protected ArmorStand armorStand;
    protected ItemStack dropItem;
    private int invalidBypassTicks = 0;
    private Mob airlift;
    private int leashReattachTicks = 0;

    public Pet(UltraPlayer owner, PetType petType, UltraCosmetics ultraCosmetics, ItemStack dropItem) {
        super(owner, petType, ultraCosmetics);
        this.dropItem = dropItem;
    }

    public Pet(UltraPlayer owner, PetType petType, UltraCosmetics ultraCosmetics, XMaterial dropItem) {
        this(owner, petType, ultraCosmetics, dropItem.parseItem());
    }

    public Pet(UltraPlayer owner, PetType petType, UltraCosmetics ultraCosmetics) {
        this(owner, petType, ultraCosmetics, petType.getItemStack());
    }

    @Override
    protected void onEquip() {
        this.initializeEntity();
    }

    private void initializeEntity() {
        this.entity = this.spawnEntity();
        Entity entity = this.entity;
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            if (SettingsManager.getConfig().getBoolean("Pets-Are-Babies")) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
            Entity entity2 = this.entity;
            if (entity2 instanceof Breedable) {
                Breedable breedable = (Breedable)entity2;
                breedable.setAgeLock(true);
            }
        }
        if (this.entity instanceof Tameable) {
            ((Tameable)this.entity).setTamed(true);
        }
        this.setupNameTag();
        EntityBrain brain = this.clearPathfinders((Mob)this.entity);
        brain.getGoalAI().put(new PetPathfinder((Mob)this.entity, this.getPlayer()), 0);
        brain.getGoalAI().put(new PathfinderLookAtEntity<Player>((Mob)this.entity, Player.class), 1);
        this.updateName();
        ((Mob)this.entity).getEquipment().clear();
        ((Mob)this.entity).setRemoveWhenFarAway(false);
        ((Mob)this.entity).setPersistent(false);
        if (SettingsManager.getConfig().getBoolean("Pets-Are-Silent")) {
            ((Mob)this.entity).setSilent(true);
        }
        if (!SettingsManager.getConfig().getBoolean("Pets-Have-Collision", true)) {
            ((Mob)this.entity).setCollidable(false);
        }
        ((Mob)this.entity).setMetadata("Pet", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)"UltraCosmetics"));
        this.setupEntity();
    }

    private EntityBrain clearPathfinders(Mob entity) {
        EntityBrain brain = BukkitBrain.getBrain(entity);
        brain.getGoalAI().clear();
        brain.getTargetAI().clear();
        brain.getScheduleManager().clear();
        return brain;
    }

    @Override
    protected void scheduleTask() {
        this.task = this.getUltraCosmetics().getScheduler().runAtEntityTimer((Entity)this.getPlayer(), this::run, 1L, 3L);
    }

    @Override
    public boolean tryEquip() {
        if (((PetType)this.getType()).isMonster() && this.getPlayer().getWorld().getDifficulty() == Difficulty.PEACEFUL) {
            this.getOwner().sendMessage(MessageManager.getMessage("Mounts.Cant-Spawn", new TagResolver.Single[0]));
            return false;
        }
        return true;
    }

    public boolean useArmorStandNameTag() {
        return this.isCustomEntity();
    }

    public boolean useMarkerArmorStand() {
        return true;
    }

    @Override
    public void run() {
        if (this.entity != null && !((Mob)this.entity).isValid()) {
            if (this.invalidBypassTicks > 0) {
                --this.invalidBypassTicks;
                return;
            }
            this.clear();
            return;
        }
        this.invalidBypassTicks = 0;
        if (!this.getOwner().isOnline() || this.getOwner().getCurrentPet() != this) {
            this.clear();
            return;
        }
        if (((Mob)this.entity).getWorld() != this.getPlayer().getWorld()) {
            this.removeEntity();
            this.initializeEntity();
        }
        if (SettingsManager.getConfig().getBoolean("Airlift-Pets")) {
            this.doAirlift();
        }
        this.onUpdate();
    }

    protected void doAirlift() {
        if (!XEntityType.HAPPY_GHAST.isSupported() || ((Mob)this.entity).getAttribute(FLYING_SPEED) != null) {
            return;
        }
        if (this.airlift != null) {
            if (!this.getPlayer().isFlying()) {
                ((Mob)this.entity).setLeashHolder(null);
                this.AIRLIFT_POOF.spawn(this.airlift.getLocation());
                this.removeEntitySafe((Entity)this.airlift);
                this.airlift = null;
            } else if (!((Mob)this.entity).isLeashed()) {
                if (this.leashReattachTicks == 0) {
                    this.leashReattachTicks = 2;
                } else if (--this.leashReattachTicks == 0) {
                    ((Mob)this.entity).setLeashHolder((Entity)this.airlift);
                }
            }
            return;
        }
        if (!this.getPlayer().isFlying()) {
            return;
        }
        this.airlift = EntitySpawningManager.withBypass(() -> (Mob)((Mob)this.entity).getWorld().spawnEntity(((Mob)this.entity).getLocation(), XEntityType.HAPPY_GHAST.get()));
        ((Mob)this.entity).setLeashHolder((Entity)this.airlift);
        this.AIRLIFT_POOF.spawn(this.airlift.getLocation());
        this.airlift.getAttribute(FLYING_SPEED).setBaseValue(0.2);
        this.airlift.getAttribute((Attribute)XAttribute.SCALE.get()).setBaseValue(0.2);
        this.airlift.setRemoveWhenFarAway(false);
        this.airlift.setPersistent(false);
        Material harness = ItemFactory.randomFromTag((Tag<Material>)Tag.ITEMS_HARNESSES);
        this.airlift.getEquipment().setItem(EquipmentSlot.BODY, new ItemStack(harness));
        this.airlift.setMetadata("Pet", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)"UltraCosmetics"));
        EntityBrain brain = this.clearPathfinders(this.airlift);
        brain.getGoalAI().put(new PetPathfinder(this.airlift, this.getPlayer(), 5.0, 20.0, -5.0), 0);
    }

    @Override
    protected void onClear() {
        if (this.airlift != null) {
            ((Mob)this.entity).setLeashHolder(null);
            this.removeEntitySafe((Entity)this.airlift);
        }
        this.removeEntitySafe((Entity)this.armorStand);
        this.removeEntity();
        this.items.stream().filter(Entity::isValid).forEach(x$0 -> this.removeEntitySafe((Entity)x$0));
        this.items.clear();
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public boolean hasArmorStand() {
        return this.armorStand != null;
    }

    public List<Item> getItems() {
        return this.items;
    }

    protected void setupNameTag() {
        if (!this.showName) {
            return;
        }
        if (!this.useArmorStandNameTag()) {
            ((Mob)this.getEntity()).setCustomNameVisible(true);
            return;
        }
        this.armorStand = (ArmorStand)((Mob)this.entity).getWorld().spawnEntity(((Mob)this.entity).getLocation(), EntityType.ARMOR_STAND);
        this.armorStand.setVisible(false);
        this.armorStand.setSmall(true);
        this.armorStand.setMarker(this.useMarkerArmorStand());
        this.armorStand.setCustomNameVisible(true);
        FixedMetadataValue metadataValue = new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)"C_AD_ArmorStand");
        this.armorStand.setPersistent(false);
        this.armorStand.setMetadata("C_AD_ArmorStand", (MetadataValue)metadataValue);
        ((Mob)this.entity).addPassenger((Entity)this.armorStand);
    }

    public void updateName() {
        Component newName;
        if (!this.showName) {
            return;
        }
        Object rename = this.armorStand == null ? this.entity : this.armorStand;
        if (this.getOwner().getPetName((PetType)this.getType()) != null) {
            newName = this.getOwner().getPetName((PetType)this.getType());
            int maxLength = SettingsManager.getConfig().getInt("Max-Pet-Name-Length", -1);
            String plainName = PlainTextComponentSerializer.plainText().serialize(newName);
            if (maxLength > 0 && plainName.length() > maxLength) {
                newName = Component.text(plainName.substring(0, maxLength));
            }
        } else {
            newName = ((PetType)this.getType()).getEntityName(this.getPlayer());
        }
        boolean hasName = !PlainTextComponentSerializer.plainText().serialize(newName).isEmpty();
        ((Mob)this.getEntity()).setCustomNameVisible(hasName);
        if (hasName) {
            this.getUltraCosmetics().getPaperSupport().setCustomName((Nameable)rename, newName);
        }
    }

    @Override
    public void onUpdate() {
        if (SettingsManager.getConfig().getBoolean("Pets-Drop-Items")) {
            this.dropItem();
        }
    }

    public void dropItem() {
        Vector velocity = new Vector(RANDOM.nextDouble() - 0.5, RANDOM.nextDouble() / 2.0 + 0.3, RANDOM.nextDouble() - 0.5).multiply(0.4);
        Item drop = ItemFactory.spawnUnpickableItem(this.dropItem, ((LivingEntity)this.entity).getEyeLocation(), velocity);
        this.items.add(drop);
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)drop, () -> {
            drop.remove();
            this.items.remove(drop);
        }, 5L);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() == this.getEntity()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getPlayer() == this.getPlayer() && event.getFrom().getWorld() == event.getTo().getWorld()) {
            this.getUltraCosmetics().getScheduler().teleportAsync(this.entity, event.getTo());
            this.invalidBypassTicks = 20;
        }
    }

    @EventHandler
    public void onMount(VehicleEnterEvent event) {
        if (!this.canRide && event.getEntered() == this.entity) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCombust(EntityCombustEvent event) {
        if (event.getEntity() == this.entity) {
            event.setCancelled(true);
        }
    }

    @Override
    protected Component appendActivateMessage(Component base) {
        Component name = this.getOwner().getPetName((PetType)this.getType());
        if (name == null) {
            return base;
        }
        return ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(base)).append(Component.text(" (", (TextColor)NamedTextColor.GRAY))).append(name)).append(Component.text(")", (TextColor)NamedTextColor.GRAY));
    }

    public boolean isCustomEntity() {
        return false;
    }

    public boolean customize(String customization) {
        return false;
    }

    protected <T extends Enum<T>> boolean enumCustomize(Class<T> types, String arg, Consumer<T> func) {
        return this.valueCustomize(s -> Enum.valueOf(types, s), arg, func);
    }

    protected <T> boolean oldEnumCustomize(Class<T> types, String arg, Consumer<T> func) {
        return this.valueCustomize(s -> {
            try {
                return types.getDeclaredField((String)s).get(null);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException(e);
            }
        }, arg, func);
    }

    protected <T> boolean valueCustomize(Function<String, T> valueFunc, String arg, Consumer<T> func) {
        T value;
        try {
            value = valueFunc.apply(arg.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        func.accept(value);
        return true;
    }

    protected boolean customizeHeldItem(String customization) {
        String[] parts = customization.split(":", 2);
        Optional mat = XMaterial.matchXMaterial((String)parts[0]);
        if (!mat.isPresent() || !((XMaterial)mat.get()).get().isItem()) {
            return false;
        }
        ItemStack stack = ((XMaterial)mat.get()).parseItem();
        if (parts.length > 1) {
            int model;
            try {
                model = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            ItemFactory.setCustomModelData(stack, model);
        }
        ((Mob)this.entity).getEquipment().setItemInMainHand(stack);
        return true;
    }
}

