/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.projectileeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.projectileeffects.ProjectileEffectBasicTrail;
import be.isach.ultracosmetics.cosmetics.type.ProjectileEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import com.cryptomorin.xseries.XSound;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.entity.Projectile;

public class ProjectileEffectNote
extends ProjectileEffectBasicTrail {
    private static final Sound SOUND = (Sound)XSound.BLOCK_NOTE_BLOCK_HARP.get();
    private final Map<UUID, Integer> colors = new HashMap<UUID, Integer>();

    public ProjectileEffectNote(UltraPlayer owner, ProjectileEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.display.withExtra(1.0);
    }

    @Override
    public void showParticles(Projectile projectile) {
        int color = this.colors.getOrDefault(projectile.getUniqueId(), 0);
        this.display.withNoteColor(color).spawn(projectile.getLocation());
        float pitch = (float)Math.pow(2.0, (float)(color - 12) / 12.0f);
        this.getPlayer().playSound(projectile.getLocation(), SOUND, 1.0f, pitch);
        if (++color > 24) {
            color = 0;
        }
        this.colors.put(projectile.getUniqueId(), color);
    }

    @Override
    public void projectileLanded(Projectile projectile) {
        this.colors.remove(projectile.getUniqueId());
    }
}

