/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.suits;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.ArmorCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.function.Consumer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Suit
extends ArmorCosmetic<SuitType> {
    protected boolean fullSuitEquipped = false;

    public Suit(UltraPlayer ultraPlayer, SuitType suitType, UltraCosmetics ultraCosmetics) {
        super(ultraPlayer, suitType, ultraCosmetics);
        this.setupItemStack();
    }

    protected boolean isFullSuit() {
        for (ArmorSlot slot : ArmorSlot.values()) {
            Suit part = this.getOwner().getCurrentSuit(slot);
            if (part != null && ((SuitType)part.getType()).getSuitCategory() == ((SuitType)this.getType()).getSuitCategory()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.getPlayer() == null || this.getOwner().getCurrentSuit(this.getArmorSlot()) != this) {
            return;
        }
        if (this.getArmorSlot() == ArmorSlot.CHESTPLATE) {
            boolean full = this.isFullSuit();
            if (!this.fullSuitEquipped && full) {
                this.chestplateOnFullSuitEquipped();
            } else if (this.fullSuitEquipped && !full) {
                this.chestplateOnFullSuitUnequipped();
            }
            this.fullSuitEquipped = full;
        }
        ((Updatable)((Object)this)).onUpdate();
    }

    protected void setupItemStack() {
        this.itemStack = ItemFactory.rename(((SuitType)this.getType()).getItemStack(), this.getTypeName(), "", MessageManager.getLegacyMessage("Suits.Suit-Part-Lore", new TagResolver.Single[0]));
    }

    @Override
    protected void onEquip() {
    }

    protected void chestplateOnFullSuitEquipped() {
    }

    protected void chestplateOnFullSuitUnequipped() {
    }

    protected void updateMeta(Consumer<ItemMeta> func) {
        ItemStack item = this.getArmorItem();
        ItemMeta meta = item.getItemMeta();
        func.accept(meta);
        item.setItemMeta(meta);
        this.setArmorItem(item);
    }

    @Override
    public ArmorSlot getArmorSlot() {
        return ((SuitType)this.cosmeticType).getSlot();
    }

    @Override
    public String getOccupiedSlotKey() {
        return "Must-Remove.Suits." + this.getArmorSlot().toString();
    }

    @Override
    protected String getOptionPath(String key) {
        return ((SuitType)this.getType()).getSuitCategory().getConfigPath() + "." + key;
    }
}

