/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.suits;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.suits.Suit;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.BlockUtils;
import com.cryptomorin.xseries.XMaterial;
import java.util.HashMap;
import java.util.List;
import org.bukkit.block.Block;

public abstract class TrailSuit
extends Suit
implements Updatable {
    private final boolean trailEnabled = SettingsManager.getConfig().getBoolean(this.getOptionPath("Trail"), true);
    private final List<XMaterial> trailBlocks = this.getTrailBlocks();

    public TrailSuit(UltraPlayer ultraPlayer, SuitType suitType, UltraCosmetics ultraCosmetics) {
        super(ultraPlayer, suitType, ultraCosmetics);
    }

    protected abstract List<XMaterial> getTrailBlocks();

    @Override
    public void onUpdate() {
        if (!this.trailEnabled || !this.isFullSuit()) {
            return;
        }
        Block block = this.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).getBlock();
        if (BlockUtils.isAir(block.getType()) || BlockUtils.isRestoring(block)) {
            return;
        }
        int index = (block.getX() + block.getZ()) % this.trailBlocks.size();
        HashMap<Block, XMaterial> updates = new HashMap<Block, XMaterial>();
        updates.put(block, this.trailBlocks.get(index));
        BlockUtils.setToRestore(updates, 60);
    }
}

