/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.suits.Suit;
import be.isach.ultracosmetics.cosmetics.suits.SuitAstronaut;
import be.isach.ultracosmetics.cosmetics.suits.SuitCursed;
import be.isach.ultracosmetics.cosmetics.suits.SuitDiamond;
import be.isach.ultracosmetics.cosmetics.suits.SuitFrozen;
import be.isach.ultracosmetics.cosmetics.suits.SuitRave;
import be.isach.ultracosmetics.cosmetics.suits.SuitSanta;
import be.isach.ultracosmetics.cosmetics.suits.SuitSlime;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.SmartLogger;
import com.cryptomorin.xseries.XItemStack;
import com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class SuitCategory {
    private static final List<SuitCategory> VALUES = new ArrayList<SuitCategory>();
    private final String configName;
    private final ItemStack helmetItem;
    private final ItemStack chestplateItem;
    private final ItemStack leggingsItem;
    private final ItemStack bootsItem;
    private SuitType helmet;
    private SuitType chestplate;
    private SuitType leggings;
    private SuitType boots;
    private final Class<? extends Suit> clazz;

    public static void register() {
        new SuitCategory("Rave", XMaterial.LEATHER_HELMET, XMaterial.LEATHER_CHESTPLATE, XMaterial.LEATHER_LEGGINGS, XMaterial.LEATHER_BOOTS, s -> Color.fromRGB((int)MathUtils.random(255), (int)MathUtils.random(255), (int)MathUtils.random(255)), SuitRave.class){

            @Override
            public void setupConfig(CustomConfiguration config, String path) {
                config.addDefault(path + ".Update-Delay-In-Creative", (Object)10, "How many ticks UC should wait between updating the rave suit for creative players.", "Setting this to a higher value allows more time between updates,", "meaning players shouldn't have their inventories close immediately after opening.", "Set to 1 or less to update every tick.");
            }
        };
        new SuitCategory("Astronaut", XMaterial.GLASS, XMaterial.GOLDEN_CHESTPLATE, XMaterial.GOLDEN_LEGGINGS, XMaterial.GOLDEN_BOOTS, s -> null, SuitAstronaut.class){

            @Override
            public void setupConfig(CustomConfiguration config, String path) {
                config.addDefault(path + ".Antigravity", (Object)true, "Whether the antigravity effect will be enabled when a player is wearing the whole suit.", "Only supported on 1.20.5+");
            }
        };
        new SuitCategoryTrail("Diamond", XMaterial.DIAMOND_HELMET, XMaterial.DIAMOND_CHESTPLATE, XMaterial.DIAMOND_LEGGINGS, XMaterial.DIAMOND_BOOTS, s -> null, SuitDiamond.class);
        new SuitCategoryTrail("Santa", XMaterial.LEATHER_HELMET, XMaterial.LEATHER_CHESTPLATE, XMaterial.LEATHER_LEGGINGS, XMaterial.LEATHER_BOOTS, s -> Color.RED, SuitSanta.class);
        new SuitCategoryTrail("Frozen", XMaterial.PACKED_ICE, XMaterial.LEATHER_CHESTPLATE, XMaterial.LEATHER_LEGGINGS, XMaterial.LEATHER_BOOTS, s -> s == ArmorSlot.HELMET ? null : Color.AQUA, SuitFrozen.class);
        new SuitCategoryTrail("Cursed", XMaterial.JACK_O_LANTERN, XMaterial.LEATHER_CHESTPLATE, XMaterial.LEATHER_LEGGINGS, XMaterial.LEATHER_BOOTS, s -> s == ArmorSlot.HELMET ? null : Color.fromRGB((int)35, (int)30, (int)42), SuitCursed.class);
        new SuitCategory("Slime", XMaterial.SLIME_BLOCK, XMaterial.LEATHER_CHESTPLATE, XMaterial.LEATHER_LEGGINGS, XMaterial.LEATHER_BOOTS, s -> s == ArmorSlot.HELMET ? null : Color.fromRGB((int)128, (int)241, (int)95), SuitSlime.class){

            @Override
            public void setupConfig(CustomConfiguration config, String path) {
                config.addDefault(path + ".Jump-Boost", (Object)true, "Whether the player will get jump boost when wearing the whole suit.");
            }
        };
        ConfigurationSection customSection = CosmeticType.getCustomConfig(Category.SUITS_HELMET);
        if (customSection != null) {
            SuitCategory.loadCustom(customSection);
        }
    }

    private static void loadCustom(ConfigurationSection custom) {
        SmartLogger log = UltraCosmeticsData.get().getPlugin().getSmartLogger();
        for (String key : custom.getKeys(false)) {
            if (!custom.isConfigurationSection(key)) continue;
            ConfigurationSection section = custom.getConfigurationSection(key);
            ItemStack helmetItem = SuitCategory.loadPart(section, "Helmet");
            ItemStack chestplateItem = SuitCategory.loadPart(section, "Chestplate");
            ItemStack leggingsItem = SuitCategory.loadPart(section, "Leggings");
            ItemStack bootsItem = SuitCategory.loadPart(section, "Boots");
            if (helmetItem == null || chestplateItem == null || leggingsItem == null || bootsItem == null) {
                log.write(SmartLogger.LogLevel.WARNING, "Incomplete custom suit '" + key + "' (one or more of [helmet, chestplate, leggings, boots] is missing)");
                continue;
            }
            SuitCategory.addDefaultStrings(key);
            new SuitCategory(key, helmetItem, chestplateItem, leggingsItem, bootsItem, Suit.class);
        }
    }

    private static ItemStack loadPart(ConfigurationSection section, String key) {
        if (!section.isConfigurationSection(key)) {
            return null;
        }
        return XItemStack.deserialize((ConfigurationSection)section.getConfigurationSection(key));
    }

    private static void addDefaultStrings(String key) {
        String configPath = Category.SUITS_HELMET.getConfigPath() + "." + key;
        MessageManager.addMessage(configPath + ".whole-equip", "<bold>whole</bold> " + key + " <bold>suit");
        MessageManager.addMessage(configPath + ".helmet-name", key + " <bold>Helmet");
        MessageManager.addMessage(configPath + ".chestplate-name", key + " <bold>Chestplate");
        MessageManager.addMessage(configPath + ".leggings-name", key + " <bold>Leggings");
        MessageManager.addMessage(configPath + ".boots-name", key + " <bold>Boots");
        MessageManager.addMessage(configPath + ".Description", "A custom suit!");
    }

    private SuitCategory(String configName, XMaterial helmet, XMaterial chestplate, XMaterial leggings, XMaterial boots, Function<ArmorSlot, Color> colorFunc, Class<? extends Suit> clazz) {
        this.configName = configName;
        this.clazz = clazz;
        this.helmetItem = this.colorize(helmet.parseItem(), colorFunc.apply(ArmorSlot.HELMET));
        this.chestplateItem = this.colorize(chestplate.parseItem(), colorFunc.apply(ArmorSlot.CHESTPLATE));
        this.leggingsItem = this.colorize(leggings.parseItem(), colorFunc.apply(ArmorSlot.LEGGINGS));
        this.bootsItem = this.colorize(boots.parseItem(), colorFunc.apply(ArmorSlot.BOOTS));
        VALUES.add(this);
    }

    private SuitCategory(String configName, ItemStack helmet, ItemStack chestplate, ItemStack leggings, ItemStack boots, Class<? extends Suit> clazz) {
        this.configName = configName;
        this.clazz = clazz;
        this.helmetItem = helmet;
        this.chestplateItem = chestplate;
        this.leggingsItem = leggings;
        this.bootsItem = boots;
        VALUES.add(this);
    }

    public void initializeSuitParts() {
        this.helmet = new SuitType(this.getHelmetItem(), ArmorSlot.HELMET, this);
        this.chestplate = new SuitType(this.getChestplateItem(), ArmorSlot.CHESTPLATE, this);
        this.leggings = new SuitType(this.getLeggingsItem(), ArmorSlot.LEGGINGS, this);
        this.boots = new SuitType(this.getBootsItem(), ArmorSlot.BOOTS, this);
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigPath() {
        return this.helmet.getConfigPath();
    }

    public Class<? extends Suit> getSuitClass() {
        return this.clazz;
    }

    public SuitType getHelmet() {
        return this.helmet;
    }

    public SuitType getChestplate() {
        return this.chestplate;
    }

    public SuitType getLeggings() {
        return this.leggings;
    }

    public SuitType getBoots() {
        return this.boots;
    }

    protected ItemStack getHelmetItem() {
        return this.helmetItem;
    }

    protected ItemStack getChestplateItem() {
        return this.chestplateItem;
    }

    protected ItemStack getLeggingsItem() {
        return this.leggingsItem;
    }

    protected ItemStack getBootsItem() {
        return this.bootsItem;
    }

    public boolean isEnabled() {
        return SettingsManager.getConfig().getBoolean("Suits." + this.configName + ".Enabled");
    }

    public SuitType getPiece(ArmorSlot slot) {
        return switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorSlot.HELMET -> this.getHelmet();
            case ArmorSlot.CHESTPLATE -> this.getChestplate();
            case ArmorSlot.LEGGINGS -> this.getLeggings();
            case ArmorSlot.BOOTS -> this.getBoots();
        };
    }

    protected ItemStack colorize(ItemStack stack, Color color) {
        ItemMeta itemMeta;
        if (color != null && (itemMeta = stack.getItemMeta()) instanceof LeatherArmorMeta) {
            LeatherArmorMeta colorMeta = (LeatherArmorMeta)itemMeta;
            colorMeta.setColor(color);
            stack.setItemMeta((ItemMeta)colorMeta);
        }
        return stack;
    }

    public List<SuitType> getPieces() {
        return Arrays.asList(this.getHelmet(), this.getChestplate(), this.getLeggings(), this.getBoots());
    }

    public void setupConfig(CustomConfiguration config, String path) {
    }

    public static List<SuitCategory> values() {
        return VALUES;
    }

    public static List<SuitCategory> enabled() {
        return SuitCategory.values().stream().filter(SuitCategory::isEnabled).collect(Collectors.toList());
    }

    private static class SuitCategoryTrail
    extends SuitCategory {
        private SuitCategoryTrail(String configName, XMaterial helmet, XMaterial chestplate, XMaterial leggings, XMaterial boots, Function<ArmorSlot, Color> colorFunc, Class<? extends Suit> clazz) {
            super(configName, helmet, chestplate, leggings, boots, colorFunc, clazz);
        }

        @Override
        public void setupConfig(CustomConfiguration config, String path) {
            config.addDefault(path + ".Trail", (Object)true, "Whether to enable the trail when wearing the whole suit.");
        }
    }
}

