/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.economy;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.economy.CoinsEngineHook;
import be.isach.ultracosmetics.economy.EconomyHook;
import be.isach.ultracosmetics.economy.EconomyHookLoader;
import be.isach.ultracosmetics.economy.PEconomyHook;
import be.isach.ultracosmetics.economy.PlayerPointsHook;
import be.isach.ultracosmetics.economy.TreasuryHook;
import be.isach.ultracosmetics.economy.VaultHook;
import be.isach.ultracosmetics.util.Discount;
import be.isach.ultracosmetics.util.SmartLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class EconomyHandler {
    private static final Map<String, EconomyHookLoader> economies = new HashMap<String, EconomyHookLoader>();
    private final UltraCosmetics ultraCosmetics;
    private EconomyHook economyHook;
    private String currency;
    private boolean usingEconomy = false;
    private boolean waitingForCustomEconomy = false;
    private final List<Discount> discounts = new ArrayList<Discount>();

    public EconomyHandler(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        String economy = ultraCosmetics.getConfig().getString("Economy", "").toLowerCase(Locale.ROOT);
        if (economy.isEmpty()) {
            ultraCosmetics.getSmartLogger().write("Economy not specified in the config, disabling economy features.");
            return;
        }
        this.loadDiscounts();
        this.currency = ultraCosmetics.getConfig().getString("Economy-Currency", "");
        if (this.currency.isEmpty()) {
            this.currency = null;
        }
        ultraCosmetics.getSmartLogger().write("");
        EconomyHookLoader hookLoader = economies.get(economy);
        if (hookLoader != null) {
            this.loadHook(hookLoader);
            return;
        }
        if (Bukkit.getPluginManager().getPlugin(economy) == null) {
            ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Unknown economy: '" + economy + "'. Valid economies: " + String.join((CharSequence)", ", economies.keySet()));
            ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Economy features will be disabled.");
        } else {
            ultraCosmetics.getSmartLogger().write("Economy plugin " + economy + " is unknown, waiting for it to register itself.");
            this.waitingForCustomEconomy = true;
        }
    }

    private void loadDiscounts() {
        ConfigurationSection section = SettingsManager.getConfig().getConfigurationSection("Discount-Groups");
        for (String key : section.getKeys(false)) {
            if (!section.isDouble(key)) continue;
            this.discounts.add(new Discount(key, section.getDouble(key)));
        }
        Collections.sort(this.discounts);
    }

    private void loadHook(EconomyHookLoader loader) {
        try {
            this.economyHook = loader.load(this.ultraCosmetics, this.currency);
        }
        catch (IllegalArgumentException | IllegalStateException | UnsupportedClassVersionError e) {
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, e.getMessage());
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Economy features will be disabled.");
            return;
        }
        catch (Exception e) {
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to hook into " + loader.getClass().getName() + " for economy.");
            e.printStackTrace();
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Economy features will be disabled.");
            return;
        }
        this.ultraCosmetics.getSmartLogger().write("Hooked into " + this.economyHook.getName() + " for economy.");
        this.usingEconomy = true;
        this.ultraCosmetics.getSmartLogger().write("");
    }

    public EconomyHook getHook() {
        return this.economyHook;
    }

    public void addHook(EconomyHookLoader loader) {
        if (this.waitingForCustomEconomy) {
            this.loadHook(loader);
            if (this.usingEconomy) {
                this.waitingForCustomEconomy = false;
            }
        } else {
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Economy already loaded, ignoring additional hook from " + loader.getClass().getName());
        }
    }

    public void withdrawWithDiscount(Player player, int amount, Runnable onSuccess, Runnable onFailure) {
        this.economyHook.withdraw(player, this.calculateDiscountPrice(player, amount), onSuccess, onFailure);
    }

    public int calculateDiscountPrice(Player player, int amount) {
        for (Discount discount : this.discounts) {
            if (!discount.hasPermission(player)) continue;
            return (int)((double)amount * discount.getDiscount());
        }
        return amount;
    }

    public boolean isUsingEconomy() {
        return this.usingEconomy;
    }

    static {
        economies.put("treasury", (uc, currency) -> new TreasuryHook(uc, currency));
        economies.put("vault", (uc, currency) -> new VaultHook());
        economies.put("playerpoints", (uc, currency) -> new PlayerPointsHook());
        economies.put("peconomy", (uc, currency) -> new PEconomyHook(uc, currency));
        economies.put("coinsengine", (uc, currency) -> new CoinsEngineHook(uc, currency));
    }
}

