/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.economy;

import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.economy.EconomyHook;
import java.util.Locale;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook
implements EconomyHook {
    private final Economy economy;
    private final boolean nonnegative;
    private final boolean ignoreResponse;

    public VaultHook() {
        if (!Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            throw new IllegalStateException("Vault is not present.");
        }
        RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (economyProvider == null) {
            throw new IllegalStateException("Found Vault but no economy, please check whether your economy plugin supports Vault.");
        }
        this.economy = (Economy)economyProvider.getProvider();
        String validation = SettingsManager.getConfig().getString("Vault-Balance-Validation", "delegate").toLowerCase(Locale.ROOT);
        this.nonnegative = validation.endsWith("nonnegative");
        this.ignoreResponse = validation.equals("force-nonnegative");
    }

    @Override
    public void withdraw(Player player, int amount, Runnable onSuccess, Runnable onFailure) {
        if (this.nonnegative && this.economy.getBalance((OfflinePlayer)player) < (double)amount) {
            onFailure.run();
            return;
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, (double)amount);
        if (this.ignoreResponse || response.type == EconomyResponse.ResponseType.SUCCESS) {
            onSuccess.run();
        } else {
            onFailure.run();
        }
    }

    @Override
    public void deposit(Player player, int amount) {
        this.economy.depositPlayer((OfflinePlayer)player, (double)amount);
    }

    @Override
    public String getName() {
        return "Vault:" + this.economy.getName();
    }
}

