/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.CommandManager;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.menu.Menu;
import be.isach.ultracosmetics.menu.buttons.ClearCosmeticButton;
import be.isach.ultracosmetics.menu.buttons.CosmeticButton;
import be.isach.ultracosmetics.menu.buttons.FilterCosmeticsButton;
import be.isach.ultracosmetics.menu.buttons.MainMenuButton;
import be.isach.ultracosmetics.menu.buttons.NextPageButton;
import be.isach.ultracosmetics.menu.buttons.PreviousPageButton;
import be.isach.ultracosmetics.permissions.PermissionManager;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.TextComponent;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.NamedTextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextDecoration;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;

public abstract class CosmeticMenu<T extends CosmeticType<?>>
extends Menu {
    public static final int[] COSMETICS_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
    protected final Category category;
    protected final PermissionManager pm;
    private final Map<UUID, Integer> lastUsedPages;
    protected final boolean hideNoPermissionItems;

    public CosmeticMenu(UltraCosmetics ultraCosmetics, Category category) {
        super(category.getConfigPath(), ultraCosmetics);
        this.pm = this.ultraCosmetics.getPermissionManager();
        this.lastUsedPages = new HashMap<UUID, Integer>();
        this.hideNoPermissionItems = SettingsManager.getConfig().getBoolean("No-Permission.Dont-Show-Item");
        this.category = category;
    }

    @Override
    public void open(UltraPlayer player) {
        this.open(player, 1);
    }

    public void open(UltraPlayer player, int page) {
        if (!this.category.isEnabled()) {
            throw new IllegalStateException("Cannot show menu for disabled category");
        }
        if (!player.getBukkitPlayer().hasPermission(this.permission)) {
            CommandManager.sendNoPermissionMessage((CommandSender)player.getBukkitPlayer());
            return;
        }
        int maxPages = this.getMaxPages(player);
        if (page > maxPages) {
            page = maxPages;
        }
        if (page < 1) {
            page = 1;
        }
        this.lastUsedPages.put(player.getUUID(), page);
        Inventory inventory = this.createInventory(maxPages == 1 ? this.getName() : this.getName(page, player));
        boolean hasUnlockable = this.hasUnlockable(player);
        Map<Integer, T> slots = this.getSlots(page, player);
        for (Map.Entry<Integer, T> entry : slots.entrySet()) {
            int slot = entry.getKey();
            CosmeticType cosmeticType = (CosmeticType)entry.getValue();
            if (this.shouldHideItem(player, cosmeticType)) continue;
            CosmeticButton button = CosmeticButton.fromType(cosmeticType, player, this.ultraCosmetics);
            this.putItem(inventory, slot, button, player);
        }
        if (page > 1) {
            this.putItem(inventory, this.getSize() - 18, new PreviousPageButton(), player);
        }
        if (page < maxPages) {
            this.putItem(inventory, this.getSize() - 10, new NextPageButton(), player);
        }
        this.putItem(inventory, inventory.getSize() - 5, new ClearCosmeticButton(this.category), player);
        if (this.getCategory().hasGoBackArrow()) {
            this.putItem(inventory, inventory.getSize() - 6, new MainMenuButton(this.ultraCosmetics), player);
        }
        if (hasUnlockable && !this.hideNoPermissionItems) {
            this.putItem(inventory, inventory.getSize() - 3, new FilterCosmeticsButton(), player);
        }
        this.putItems(inventory, player, page);
        this.fillInventory(inventory);
        player.getBukkitPlayer().openInventory(inventory);
    }

    @Override
    public void refresh(UltraPlayer player) {
        this.open(player, this.getCurrentPage(player));
    }

    public int getCurrentPage(UltraPlayer ultraPlayer) {
        return this.lastUsedPages.getOrDefault(ultraPlayer.getUUID(), 1);
    }

    protected int getMaxPages(UltraPlayer player) {
        int i = 0;
        for (CosmeticType<?> type : CosmeticType.enabledOf(this.category)) {
            if (this.shouldHideItem(player, type)) continue;
            ++i;
        }
        return Math.max(1, (i - 1) / 21 + 1);
    }

    protected int getItemsPerPage() {
        return 21;
    }

    protected Component getName(int page, UltraPlayer ultraPlayer) {
        return ((TextComponent)((TextComponent)Component.empty().append(this.getName())).appendSpace()).append(Component.text("(" + page + "/" + this.getMaxPages(ultraPlayer) + ")", (TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC));
    }

    @Override
    protected int getSize() {
        return 54;
    }

    @Override
    protected void putItems(Inventory inventory, UltraPlayer ultraPlayer) {
    }

    @Override
    protected Component getName() {
        return MessageManager.getMessage("Menu." + this.category.getConfigPath() + ".Title", new TagResolver.Single[0]);
    }

    public Category getCategory() {
        return this.category;
    }

    protected void putItems(Inventory inventory, UltraPlayer ultraPlayer, int page) {
    }

    protected Map<Integer, T> getSlots(int page, UltraPlayer player) {
        int start = 21 * (page - 1);
        int limit = 21;
        int current = 0;
        HashMap<Integer, CosmeticType> slots = new HashMap<Integer, CosmeticType>();
        ArrayList<CosmeticType> enabled = new ArrayList<CosmeticType>();
        CosmeticType.enabledOf(this.category).forEach(t -> enabled.add((CosmeticType)t));
        enabled.removeIf(k -> this.shouldHideItem(player, (CosmeticType<?>)k));
        for (int i = start; current < limit && i < enabled.size(); ++i) {
            slots.put(COSMETICS_SLOTS[current++ % 21], (CosmeticType)enabled.get(i));
        }
        return slots;
    }

    protected boolean shouldHideItem(UltraPlayer player, CosmeticType<?> cosmeticType) {
        return (this.hideNoPermissionItems || player.isFilteringByOwned()) && !player.canEquip(cosmeticType);
    }

    protected boolean hasUnlockable(UltraPlayer player) {
        if (this.ultraCosmetics.getWorldGuardManager().isInShowroom(player.getBukkitPlayer())) {
            return false;
        }
        for (CosmeticType<?> type : CosmeticType.enabledOf(this.category)) {
            if (player.canEquip(type)) continue;
            return true;
        }
        return false;
    }
}

