/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.CommandManager;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.hook.PlaceholderHook;
import be.isach.ultracosmetics.menu.Button;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.menu.CosmeticsInventoryHolder;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public abstract class Menu
implements Listener {
    public static final Permission ALL_MENUS_PERMISSION = Menu.registerAllPermission();
    private static final Map<String, Permission> REGISTERED_PERMISSIONS = new HashMap<String, Permission>();
    protected final UltraCosmetics ultraCosmetics;
    protected final Map<Inventory, Map<ItemStack, Button>> clickRunnableMap = new HashMap<Inventory, Map<ItemStack, Button>>();
    private final boolean fillEmpty = SettingsManager.getConfig().getBoolean("Fill-Blank-Slots-With-Item.Enabled");
    private final ItemStack fillerItem = this.getFillerItem();
    protected final Permission permission;

    private static Permission registerAllPermission() {
        Permission perm = Bukkit.getPluginManager().getPermission("ultracosmetics.menu.all");
        if (perm == null) {
            perm = new Permission("ultracosmetics.menu.all", PermissionDefault.TRUE);
            Bukkit.getPluginManager().addPermission(perm);
        }
        return perm;
    }

    public static List<Permission> getMenuPermissions() {
        return new ArrayList<Permission>(REGISTERED_PERMISSIONS.values());
    }

    public Menu(String name, UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        ultraCosmetics.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ultraCosmetics);
        this.permission = this.registerPermission(name);
    }

    private Permission registerPermission(String strPerm) {
        return REGISTERED_PERMISSIONS.computeIfAbsent(strPerm, s -> {
            String name = "ultracosmetics.menu." + s;
            Permission perm = Bukkit.getPluginManager().getPermission(name);
            if (perm == null) {
                perm = new Permission("ultracosmetics.menu." + s);
                Bukkit.getPluginManager().addPermission(perm);
                perm.addParent(ALL_MENUS_PERMISSION, true);
            }
            return perm;
        });
    }

    public void open(UltraPlayer player) {
        if (!player.getBukkitPlayer().hasPermission(this.permission)) {
            CommandManager.sendNoPermissionMessage((CommandSender)player.getBukkitPlayer());
            return;
        }
        player.getBukkitPlayer().openInventory(this.getInventory(player));
    }

    public void refresh(UltraPlayer player) {
        this.open(player);
    }

    protected Inventory createInventory(Component name) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new CosmeticsInventoryHolder(), (int)this.getSize(), (String)MessageManager.toLegacy(name));
        ((CosmeticsInventoryHolder)inventory.getHolder()).setInventory(inventory);
        return inventory;
    }

    public Inventory getInventory(UltraPlayer player) {
        Inventory inventory = this.createInventory(this.getName());
        this.putItems(inventory, player);
        this.fillInventory(inventory);
        return inventory;
    }

    public Permission getPermission() {
        return this.permission;
    }

    protected void putItem(Inventory inventory, int slot, Button button, UltraPlayer ultraPlayer) {
        ItemStack itemStack = button.getDisplayItem(ultraPlayer);
        if (itemStack.hasItemMeta()) {
            ItemFactory.setFlags(itemStack);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta.hasLore() && this.ultraCosmetics.getPlaceholderHook() != null) {
                Player player = ultraPlayer.getBukkitPlayer();
                List loreList = itemMeta.getLore();
                for (int i = 0; i < loreList.size(); ++i) {
                    if (!((String)loreList.get(i)).contains("%")) continue;
                    loreList.set(i, PlaceholderHook.parsePlaceholders(player, (String)loreList.get(i)));
                }
                itemMeta.setLore(loreList);
            }
            itemStack.setItemMeta(itemMeta);
        }
        inventory.setItem(slot, itemStack);
        Map map = this.clickRunnableMap.computeIfAbsent(inventory, f -> new HashMap());
        map.put(itemStack, button);
    }

    protected void fillInventory(Inventory inventory) {
        if (!this.fillEmpty) {
            return;
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null && inventory.getItem(i).getType() != Material.AIR) continue;
            inventory.setItem(i, this.fillerItem);
        }
    }

    private ItemStack getFillerItem() {
        ItemStack itemStack = ItemFactory.getItemStackFromConfig("Fill-Blank-Slots-With-Item.Item");
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(String.valueOf(ChatColor.GRAY));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!this.clickRunnableMap.containsKey(event.getInventory())) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null || !event.getCurrentItem().hasItemMeta() || !event.getCurrentItem().getItemMeta().hasDisplayName() || event.getCurrentItem().equals((Object)this.fillerItem)) {
            return;
        }
        Button button = null;
        String clickItemName = event.getCurrentItem().getItemMeta().getDisplayName();
        Set<Map.Entry<ItemStack, Button>> entries = this.clickRunnableMap.get(event.getInventory()).entrySet();
        for (Map.Entry<ItemStack, Button> entry : entries) {
            if (!entry.getKey().getItemMeta().getDisplayName().equals(clickItemName)) continue;
            button = entry.getValue();
            break;
        }
        if (button == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UltraPlayer ultraPlayer = this.ultraCosmetics.getPlayerManager().getUltraPlayer(player);
        button.onClick(new ClickData(this, ultraPlayer, event.getClick(), event.getCurrentItem(), event.getSlot()));
        player.updateInventory();
    }

    public UltraCosmetics getUltraCosmetics() {
        return this.ultraCosmetics;
    }

    protected abstract void putItems(Inventory var1, UltraPlayer var2);

    protected abstract int getSize();

    protected abstract Component getName();
}

