/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.events.UCKeyPurchaseEvent;
import be.isach.ultracosmetics.menu.CosmeticMenu;
import be.isach.ultracosmetics.menu.CosmeticsInventoryHolder;
import be.isach.ultracosmetics.menu.Menu;
import be.isach.ultracosmetics.menu.MenuPurchase;
import be.isach.ultracosmetics.menu.MenuPurchaseFactory;
import be.isach.ultracosmetics.menu.PurchaseData;
import be.isach.ultracosmetics.menu.menus.MenuDeathEffects;
import be.isach.ultracosmetics.menu.menus.MenuEmotes;
import be.isach.ultracosmetics.menu.menus.MenuGadgets;
import be.isach.ultracosmetics.menu.menus.MenuHats;
import be.isach.ultracosmetics.menu.menus.MenuMain;
import be.isach.ultracosmetics.menu.menus.MenuMorphs;
import be.isach.ultracosmetics.menu.menus.MenuMounts;
import be.isach.ultracosmetics.menu.menus.MenuParticleEffects;
import be.isach.ultracosmetics.menu.menus.MenuPets;
import be.isach.ultracosmetics.menu.menus.MenuProjectileEffects;
import be.isach.ultracosmetics.menu.menus.MenuSuits;
import be.isach.ultracosmetics.menu.menus.StandardMenuPurchase;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.TextUtil;
import com.cryptomorin.xseries.XMaterial;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class Menus {
    private final UltraCosmetics ultraCosmetics;
    private final Map<Category, CosmeticMenu<?>> categoryMenus = new HashMap();
    private Menu mainMenu;
    private MenuPurchaseFactory menuPurchaseFactory = StandardMenuPurchase::new;
    private ItemStack treasureKeyBaseItem = XMaterial.TRIPWIRE_HOOK.parseItem();

    public Menus(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        this.categoryMenus.put(Category.EMOTES, new MenuEmotes(ultraCosmetics));
        this.categoryMenus.put(Category.GADGETS, new MenuGadgets(ultraCosmetics));
        this.categoryMenus.put(Category.EFFECTS, new MenuParticleEffects(ultraCosmetics));
        this.categoryMenus.put(Category.HATS, new MenuHats(ultraCosmetics));
        this.categoryMenus.put(Category.MORPHS, new MenuMorphs(ultraCosmetics));
        this.categoryMenus.put(Category.MOUNTS, new MenuMounts(ultraCosmetics));
        this.categoryMenus.put(Category.PETS, new MenuPets(ultraCosmetics));
        this.categoryMenus.put(Category.PROJECTILE_EFFECTS, new MenuProjectileEffects(ultraCosmetics));
        this.categoryMenus.put(Category.DEATH_EFFECTS, new MenuDeathEffects(ultraCosmetics));
        MenuSuits ms = new MenuSuits(ultraCosmetics);
        this.categoryMenus.put(Category.SUITS_HELMET, ms);
        this.categoryMenus.put(Category.SUITS_CHESTPLATE, ms);
        this.categoryMenus.put(Category.SUITS_LEGGINGS, ms);
        this.categoryMenus.put(Category.SUITS_BOOTS, ms);
        this.mainMenu = new MenuMain(ultraCosmetics);
        new CosmeticsInventoryHolder();
    }

    public Menu getMainMenu() {
        return this.mainMenu;
    }

    public void setMainMenu(Menu menu) {
        this.mainMenu = menu;
    }

    public void openMainMenu(UltraPlayer ultraPlayer) {
        if (this.ultraCosmetics.getConfig().getBoolean("Categories.Back-To-Main-Menu-Custom-Command.Enabled")) {
            String command = this.ultraCosmetics.getConfig().getString("Categories.Back-To-Main-Menu-Custom-Command.Command").replace("/", "").replace("{player}", ultraPlayer.getBukkitPlayer().getName()).replace("{playeruuid}", ultraPlayer.getUUID().toString());
            Bukkit.dispatchCommand((CommandSender)this.ultraCosmetics.getServer().getConsoleSender(), (String)command);
            return;
        }
        this.mainMenu.open(ultraPlayer);
    }

    public CosmeticMenu<?> getCategoryMenu(Category category) {
        return this.categoryMenus.get((Object)category);
    }

    public void setCategoryMenu(Category category, CosmeticMenu<?> menu) {
        this.categoryMenus.put(category, menu);
    }

    public void openAmmoPurchaseMenu(GadgetType type, UltraPlayer player, Runnable menuReturnFunc) {
        int price = this.ultraCosmetics.getEconomyHandler().calculateDiscountPrice(player.getBukkitPlayer(), type.getAmmoPrice());
        String itemName = MessageManager.getLegacyMessage("Buy-Ammo-Description", Placeholder.unparsed("amount", String.valueOf(type.getResultAmmoAmount())), Placeholder.unparsed("price", TextUtil.formatNumber(price)), Placeholder.component("gadgetname", type.getName()));
        ItemStack display = ItemFactory.create(type.getMaterial(), itemName, new String[0]);
        PurchaseData pd = new PurchaseData();
        pd.setBasePrice(type.getAmmoPrice());
        pd.setShowcaseItem(display);
        pd.setOnPurchase(() -> {
            player.addAmmo(type, type.getResultAmmoAmount());
            menuReturnFunc.run();
        });
        pd.setOnCancel(menuReturnFunc);
        MenuPurchase mp = this.menuPurchaseFactory.createPurchaseMenu(this.ultraCosmetics, MessageManager.getMessage("Menu.Buy-Ammo.Title", new TagResolver.Single[0]), pd);
        player.getBukkitPlayer().openInventory(mp.getInventory(player));
    }

    public MenuPurchaseFactory getMenuPurchaseFactory() {
        return this.menuPurchaseFactory;
    }

    public void setMenuPurchaseFactory(MenuPurchaseFactory factory) {
        this.menuPurchaseFactory = factory;
    }

    public ItemStack getTreasureKeyBaseItem() {
        return this.treasureKeyBaseItem;
    }

    public void setTreasureKeyBaseItem(ItemStack treasureKeyBaseItem) {
        this.treasureKeyBaseItem = treasureKeyBaseItem;
    }

    public void openKeyPurchaseMenu(UltraPlayer ultraPlayer) {
        if (!this.ultraCosmetics.getEconomyHandler().isUsingEconomy()) {
            return;
        }
        Player player = ultraPlayer.getBukkitPlayer();
        int price = SettingsManager.getConfig().getInt("TreasureChests.Key-Price");
        if (price < 1) {
            return;
        }
        if (!player.hasPermission("ultracosmetics.treasurechests.buykey")) {
            MessageManager.send((CommandSender)player, "No-Buy-Key-Permission", new TagResolver.Single[0]);
            return;
        }
        int discountPrice = this.ultraCosmetics.getEconomyHandler().calculateDiscountPrice(player, price);
        TagResolver.Single pricePlaceholder = Placeholder.unparsed("price", TextUtil.formatNumber(discountPrice));
        ItemStack itemStack = ItemFactory.rename(this.getTreasureKeyBaseItem(), MessageManager.getLegacyMessage("Buy-Treasure-Key-ItemName", pricePlaceholder), new String[0]);
        PurchaseData pd = new PurchaseData();
        pd.setBasePrice(discountPrice);
        pd.setShowcaseItem(itemStack);
        pd.setCanPurchase(() -> {
            UCKeyPurchaseEvent event = new UCKeyPurchaseEvent(ultraPlayer, discountPrice);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            pd.setBasePrice(event.getPrice());
            return true;
        });
        Menus menus = this.ultraCosmetics.getMenus();
        pd.setOnPurchase(() -> {
            ultraPlayer.addKey();
            menus.openMainMenu(ultraPlayer);
        });
        pd.setOnCancel(() -> menus.openMainMenu(ultraPlayer));
        MenuPurchase mp = menus.getMenuPurchaseFactory().createPurchaseMenu(this.ultraCosmetics, MessageManager.getMessage("Buy-Treasure-Key", new TagResolver.Single[0]), pd);
        this.ultraCosmetics.getScheduler().runAtEntityLater((Entity)player, () -> player.openInventory(mp.getInventory(ultraPlayer)), 1L);
    }
}

