/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.menu.Button;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.menu.Menu;
import be.isach.ultracosmetics.menu.MenuPurchase;
import be.isach.ultracosmetics.menu.MenuPurchaseFactory;
import be.isach.ultracosmetics.menu.PurchaseData;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.anvilgui.anvilgui.AnvilGUI;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.TextUtil;
import com.cryptomorin.xseries.XMaterial;
import java.util.Collections;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RenamePetButton
implements Button {
    private final Component activePetNeeded = MessageManager.getMessage("Active-Pet-Needed", new TagResolver.Single[0]);
    private final ItemStack stack = ItemFactory.getItemStackFromConfig("Categories.Rename-Pet-Item");
    private final UltraCosmetics ultraCosmetics;

    public RenamePetButton(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
    }

    @Override
    public ItemStack getDisplayItem(UltraPlayer ultraPlayer) {
        if (ultraPlayer.getCurrentPet() == null) {
            return ItemFactory.rename(this.stack.clone(), this.activePetNeeded, new String[0]);
        }
        Component name = MessageManager.getMessage("Menu.Rename-Pet.Button.Name", Placeholder.component("petname", ultraPlayer.getCurrentPet().getTypeName()));
        return ItemFactory.rename(this.stack.clone(), name, new String[0]);
    }

    @Override
    public void onClick(ClickData clickData) {
        UltraPlayer player = clickData.getClicker();
        if (player.getCurrentPet() == null) {
            player.sendMessage(this.activePetNeeded);
            player.getBukkitPlayer().closeInventory();
            return;
        }
        RenamePetButton.renamePet(this.ultraCosmetics, player, clickData.getMenu());
    }

    public static void renamePet(UltraCosmetics ultraCosmetics, UltraPlayer ultraPlayer, Menu returnMenu) {
        String oldName = ultraPlayer.getProfile().getPetName((PetType)ultraPlayer.getCurrentPet().getType());
        if (oldName == null) {
            oldName = MessageManager.getLegacyMessage("Menu.Rename-Pet.Placeholder", new TagResolver.Single[0]);
        }
        try {
            new AnvilGUI.Builder().plugin((Plugin)ultraCosmetics).itemLeft(XMaterial.PAPER.parseItem()).text(oldName).title(MessageManager.getLegacyMessage("Menu.Rename-Pet.Title", new TagResolver.Single[0])).onClick((Integer slot, AnvilGUI.StateSnapshot state) -> {
                if (slot != 2) {
                    return Collections.emptyList();
                }
                String text = state.getText();
                String stripped = MessageManager.getMiniMessage().stripTags(text);
                int maxLength = SettingsManager.getConfig().getInt("Max-Pet-Name-Length", -1);
                if (maxLength != -1 && stripped.length() > maxLength || text.length() > 256) {
                    return Collections.singletonList(AnvilGUI.ResponseAction.replaceInputText(MessageManager.getLegacyMessage("Too-Long", new TagResolver.Single[0])));
                }
                if (!text.isEmpty() && ultraCosmetics.getEconomyHandler().isUsingEconomy() && SettingsManager.getConfig().getBoolean("Pets-Rename.Requires-Money.Enabled")) {
                    return Collections.singletonList(AnvilGUI.ResponseAction.openInventory(RenamePetButton.buyRenamePet(ultraPlayer, text, returnMenu)));
                }
                ultraPlayer.setPetName((PetType)ultraPlayer.getCurrentPet().getType(), text);
                return Collections.singletonList(AnvilGUI.ResponseAction.close());
            }).open(ultraPlayer.getBukkitPlayer());
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            ultraPlayer.sendMessage(MessageManager.getMessage("Use-Rename-Pet-Command", new TagResolver.Single[0]));
        }
    }

    public static Inventory buyRenamePet(UltraPlayer ultraPlayer, String name, Menu returnMenu) {
        int price = SettingsManager.getConfig().getInt("Pets-Rename.Requires-Money.Price");
        int discountPrice = UltraCosmeticsData.get().getPlugin().getEconomyHandler().calculateDiscountPrice(ultraPlayer.getBukkitPlayer(), price);
        Component renameTitle = MessageManager.getMessage("Menu.Purchase-Rename.Button.Showcase", Placeholder.unparsed("price", TextUtil.formatNumber(discountPrice)), Placeholder.component("name", MessageManager.getMiniMessage().deserialize(name)));
        ItemStack showcaseItem = ItemFactory.create(XMaterial.NAME_TAG, renameTitle, new String[0]);
        PurchaseData purchaseData = new PurchaseData();
        purchaseData.setBasePrice(price);
        purchaseData.setShowcaseItem(showcaseItem);
        purchaseData.setOnPurchase(() -> {
            ultraPlayer.setPetName((PetType)ultraPlayer.getCurrentPet().getType(), name);
            if (returnMenu != null) {
                returnMenu.open(ultraPlayer);
            }
        });
        if (returnMenu != null) {
            purchaseData.setOnCancel(() -> returnMenu.open(ultraPlayer));
        }
        MenuPurchaseFactory mpFactory = UltraCosmeticsData.get().getPlugin().getMenus().getMenuPurchaseFactory();
        MenuPurchase menu = mpFactory.createPurchaseMenu(UltraCosmeticsData.get().getPlugin(), MessageManager.getMessage("Menu.Purchase-Rename.Title", new TagResolver.Single[0]), purchaseData);
        return menu.getInventory(ultraPlayer);
    }
}

