/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons.togglecosmetic;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.menu.buttons.togglecosmetic.ToggleCosmeticButton;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.List;

public class ToggleGadgetCosmeticButton
extends ToggleCosmeticButton {
    public ToggleGadgetCosmeticButton(UltraCosmetics ultraCosmetics, GadgetType cosmeticType) {
        super(ultraCosmetics, cosmeticType);
    }

    @Override
    protected void handleRightClick(ClickData clickData) {
        UltraPlayer ultraPlayer = clickData.getClicker();
        if (this.ultraCosmetics.getEconomyHandler().isUsingEconomy() && UltraCosmeticsData.get().isAmmoPurchaseEnabled() && ((GadgetType)this.cosmeticType).requiresAmmo()) {
            this.ultraCosmetics.getMenus().openAmmoPurchaseMenu((GadgetType)this.cosmeticType, ultraPlayer, () -> clickData.getMenu().refresh(ultraPlayer));
        }
    }

    @Override
    protected boolean handleActivate(ClickData clickData) {
        UltraPlayer ultraPlayer = clickData.getClicker();
        GadgetType gadgetType = (GadgetType)ultraPlayer.getCurrentGadget().getType();
        if (this.ultraCosmetics.getEconomyHandler().isUsingEconomy() && UltraCosmeticsData.get().isAmmoPurchaseEnabled() && gadgetType.requiresAmmo() && ultraPlayer.getAmmo(gadgetType) < 1) {
            this.ultraCosmetics.getMenus().openAmmoPurchaseMenu(gadgetType, ultraPlayer, () -> clickData.getMenu().refresh(ultraPlayer));
            return false;
        }
        return super.handleActivate(clickData);
    }

    @Override
    protected void modifyLore(List<String> lore, UltraPlayer ultraPlayer) {
        GadgetType gadgetType = (GadgetType)this.cosmeticType;
        if (!(UltraCosmeticsData.get().isAmmoEnabled() && gadgetType.requiresAmmo() && ultraPlayer.canEquip(gadgetType))) {
            return;
        }
        lore.add("");
        int ammo = ultraPlayer.getAmmo(gadgetType);
        lore.add(MessageManager.getLegacyMessage("Ammo", Placeholder.unparsed("ammo", String.valueOf(ammo))));
        if (this.ultraCosmetics.getEconomyHandler().isUsingEconomy()) {
            lore.add(MessageManager.getLegacyMessage("Right-Click-Buy-Ammo", new TagResolver.Single[0]));
        }
    }

    @Override
    protected int getAmount(UltraPlayer ultraPlayer) {
        boolean currentGadgetIsThis;
        boolean bl = currentGadgetIsThis = ultraPlayer.getCurrentGadget() != null && ultraPlayer.getCurrentGadget().getType() == this.cosmeticType;
        if (SettingsManager.getConfig().getBoolean("Ammo-System-For-Gadgets.Show-Ammo-In-Menu-As-Item-Amount") && !currentGadgetIsThis) {
            return Math.max(1, Math.min(64, ultraPlayer.getAmmo((GadgetType)this.cosmeticType)));
        }
        return super.getAmount(ultraPlayer);
    }
}

