/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql.query;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.mysql.column.Column;
import be.isach.ultracosmetics.mysql.query.ClauseItem;
import be.isach.ultracosmetics.mysql.query.ClauseItemLiteral;
import be.isach.ultracosmetics.mysql.query.InnerJoin;
import be.isach.ultracosmetics.mysql.query.ResultGetter;
import be.isach.ultracosmetics.mysql.tables.Table;
import be.isach.ultracosmetics.mysql.tables.TableInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;

public class StandardQuery {
    protected final Table table;
    protected final String command;
    protected final List<ClauseItem> whereItems = new ArrayList<ClauseItem>();
    protected final List<ClauseItem> setItems = new ArrayList<ClauseItem>();
    protected InnerJoin innerJoin;
    protected boolean or = false;
    protected boolean unsafe = false;

    public StandardQuery(Table table, String command) {
        this.table = table;
        this.command = command + " " + table.getWrappedName();
    }

    public StandardQuery where(ClauseItem clauseItem) {
        this.whereItems.add(clauseItem);
        return this;
    }

    public StandardQuery where(String key, Object value) {
        return this.where(new ClauseItemLiteral(key, value));
    }

    public StandardQuery uuid(UUID uuid) {
        return this.where(new ClauseItemLiteral("uuid", Table.binaryUUID(uuid)));
    }

    public StandardQuery set(ClauseItem clauseItem) {
        this.setItems.add(clauseItem);
        return this;
    }

    public StandardQuery set(String key, Object value) {
        return this.set(new ClauseItemLiteral(key, value));
    }

    public StandardQuery innerJoin(InnerJoin join) {
        this.innerJoin = join;
        return this;
    }

    public StandardQuery andOr() {
        this.or = true;
        return this;
    }

    public StandardQuery unsafe() {
        this.unsafe = true;
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T> T getResults(ResultGetter<T> processResult, boolean multiRow) {
        if (this.whereItems.size() == 0 && !this.unsafe) {
            throw new IllegalStateException("Should not execute non-INSERT query without WHERE clause");
        }
        StringBuilder sql = new StringBuilder(this.command);
        ArrayList<Object> objects = new ArrayList<Object>();
        this.addClause(sql, "SET", ", ", this.setItems, objects);
        if (this.innerJoin != null) {
            sql.append(" ").append(this.innerJoin.toSQL(this.table.getWrappedName()));
        }
        if (this.or) {
            sql.append(" WHERE ").append(this.whereItems.get(0).toSQL(objects)).append(" AND (");
            this.addClause(sql, null, " OR ", this.whereItems, objects);
            sql.append(")");
        } else {
            this.addClause(sql, "WHERE", " AND ", this.whereItems, objects);
        }
        StandardQuery.printStringified(sql, objects);
        try (Connection connection = this.table.getConnection();){
            T t;
            block24: {
                PreparedStatement statement;
                block22: {
                    T i2;
                    block23: {
                        statement = connection.prepareStatement(sql.toString());
                        try {
                            for (int i2 = 0; i2 < objects.size(); ++i2) {
                                statement.setObject(i2 + 1, objects.get(i2));
                            }
                            if (processResult != null) break block22;
                            statement.executeUpdate();
                            i2 = null;
                            if (statement == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        statement.close();
                    }
                    return i2;
                }
                ResultSet result = statement.executeQuery();
                if (!multiRow) {
                    result.next();
                }
                t = processResult.process(result);
                if (statement == null) break block24;
                statement.close();
            }
            return t;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void execute() {
        this.getResults(null, false);
    }

    public boolean exists() {
        return this.getResults(ResultSet::next, false);
    }

    public int asInt() {
        return this.getResults(r -> r.getInt(1), false);
    }

    public boolean asBool() {
        return this.getResults(r -> r.getBoolean(1), false);
    }

    public String asString() {
        return this.getResults(r -> r.getString(1), false);
    }

    public Map<String, Object> getWholeRow() {
        return this.getResults(r -> {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (TableInfo info : this.table.getTableInfo()) {
                if (!(info instanceof Column)) continue;
                values.put(((Column)info).getName(), ((Column)info).getValue(r));
            }
            return values;
        }, false);
    }

    private void addClause(StringBuilder sb, String clause, String joiner, List<ClauseItem> items, List<Object> objects) {
        if (items.size() == 0) {
            return;
        }
        if (clause != null) {
            sb.append(" ").append(clause).append(" ");
        }
        StringJoiner sj = new StringJoiner(joiner);
        for (ClauseItem item : items) {
            sj.add(item.toSQL(objects));
        }
        sb.append(sj);
    }

    public static void printStringified(StringBuilder sql, List<Object> objects) {
        if (!UltraCosmeticsData.get().getPlugin().getMySqlConnectionManager().isDebug()) {
            return;
        }
        String plaintext = sql.toString();
        for (Object obj : objects) {
            if (obj instanceof byte[]) {
                byte[] data = (byte[])obj;
                StringBuilder hex = new StringBuilder("x'");
                for (byte datum : data) {
                    hex.append(Integer.toHexString(datum & 0xFF));
                }
                hex.append("'");
                plaintext = plaintext.replaceFirst("\\?", hex.toString());
                continue;
            }
            plaintext = plaintext.replaceFirst("\\?", obj == null ? "NULL" : obj.toString());
        }
        UltraCosmeticsData.get().getPlugin().getSmartLogger().write("Executing SQL: " + plaintext);
    }
}

