/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql.tables;

import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.mysql.column.Column;
import be.isach.ultracosmetics.mysql.column.ForeignKeyConstraint;
import be.isach.ultracosmetics.mysql.column.StringColumn;
import be.isach.ultracosmetics.mysql.column.UUIDColumn;
import be.isach.ultracosmetics.mysql.column.UniqueConstraint;
import be.isach.ultracosmetics.mysql.column.VirtualUUIDColumn;
import be.isach.ultracosmetics.mysql.query.InnerJoin;
import be.isach.ultracosmetics.mysql.query.InsertQuery;
import be.isach.ultracosmetics.mysql.query.InsertValue;
import be.isach.ultracosmetics.mysql.tables.CosmeticTable;
import be.isach.ultracosmetics.mysql.tables.PlayerDataTable;
import be.isach.ultracosmetics.mysql.tables.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;

public class PetNameTable
extends Table {
    private final PlayerDataTable playerData;
    private final CosmeticTable cosmeticTable;

    public PetNameTable(DataSource dataSource, String name, PlayerDataTable playerData, CosmeticTable cosmeticTable) {
        super(dataSource, name);
        this.playerData = playerData;
        this.cosmeticTable = cosmeticTable;
    }

    @Override
    public void setupTableInfo() {
        this.tableInfo.add(new UUIDColumn());
        this.tableInfo.add(new VirtualUUIDColumn());
        this.tableInfo.add(new Column<Integer>("id", "INTEGER NOT NULL", Integer.class));
        this.tableInfo.add(new StringColumn("name", 256, false));
        this.tableInfo.add(new ForeignKeyConstraint("uuid", this.playerData.getWrappedName(), "uuid"));
        this.tableInfo.add(new ForeignKeyConstraint("id", this.cosmeticTable.getWrappedName(), "id"));
        this.tableInfo.add(new UniqueConstraint("uuid", "id"));
    }

    public String getPetName(UUID uuid, PetType type) {
        return this.select("name").uuid(uuid).where(this.cosmeticTable.subqueryFor(type, false)).asString();
    }

    public Map<PetType, String> getAllPetNames(UUID uuid) {
        return this.select("name, type").uuid(uuid).innerJoin(new InnerJoin(this.cosmeticTable.getWrappedName(), "id")).getResults(r -> {
            HashMap names = new HashMap();
            while (r.next()) {
                String name = r.getString("name");
                this.ifParseable(Category.PETS, r.getString("type"), (Category c, CosmeticType<?> t) -> names.put((PetType)t, name));
            }
            return names;
        }, true);
    }

    public void setPetName(UUID uuid, PetType type, String name) {
        if (name == null) {
            this.removePetName(uuid, type);
            return;
        }
        this.insert("uuid", "id", "name").insert(PetNameTable.insertUUID(uuid), this.cosmeticTable.subqueryFor(type, true), new InsertValue(name)).updateOnDuplicate().execute();
    }

    public void removePetName(UUID uuid, PetType type) {
        this.delete().uuid(uuid).where(this.cosmeticTable.subqueryFor(type, false)).execute();
    }

    public void setAllPetNames(UUID uuid, Map<PetType, String> names) {
        this.delete().uuid(uuid).execute();
        if (names.size() == 0) {
            return;
        }
        InsertQuery query = this.insert("uuid", "id", "name");
        InsertValue uuidVal = PetNameTable.insertUUID(uuid);
        for (Map.Entry<PetType, String> entry : names.entrySet()) {
            if (entry.getValue() == null) continue;
            query.insert(uuidVal, this.cosmeticTable.subqueryFor(entry.getKey(), true), new InsertValue(entry.getValue()));
        }
        query.updateOnDuplicate().execute();
    }
}

