/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.permissions;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.permissions.CosmeticPermissionSetter;
import be.isach.ultracosmetics.permissions.RawPermissionSetter;
import be.isach.ultracosmetics.util.SmartLogger;
import java.util.Set;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.ScopedNode;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LuckPermsHook
implements CosmeticPermissionSetter,
RawPermissionSetter {
    private final UltraCosmetics ultraCosmetics;
    private final LuckPerms api;
    private final ImmutableContextSet context;
    private boolean log = true;

    public LuckPermsHook(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        this.api = (LuckPerms)Bukkit.getServicesManager().getRegistration(LuckPerms.class).getProvider();
        String[] contexts = SettingsManager.getConfig().getString("TreasureChests.Permission-Add-Command").split(" ");
        ImmutableContextSet.Builder contextBuilder = ImmutableContextSet.builder();
        for (int i = 1; i < contexts.length; ++i) {
            if (contexts[i].equals("nolog")) {
                this.log = false;
                continue;
            }
            String[] kv = contexts[i].split("=");
            if (kv.length != 2) {
                ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Invalid LuckPerms context: " + contexts[i]);
                continue;
            }
            contextBuilder.add(kv[0], kv[1]);
        }
        this.context = contextBuilder.build();
    }

    @Override
    public void setRawPermission(Player player, String permission) {
        if (this.log) {
            this.ultraCosmetics.getSmartLogger().write("Setting permission '" + permission + "' for user " + player.getName());
        }
        this.ultraCosmetics.getScheduler().runAsync(task -> {
            User user = this.api.getPlayerAdapter(Player.class).getUser((Object)player);
            ScopedNode node = Node.builder((String)permission).value(true).context((ContextSet)this.context).build();
            user.data().add((Node)node);
            this.api.getUserManager().saveUser(user);
        });
    }

    @Override
    public void setPermissions(Player player, Set<CosmeticType<?>> types) {
        types.forEach(t -> this.setRawPermission(player, t.getPermission().getName()));
    }

    @Override
    public void unsetPermissions(Player player, Set<CosmeticType<?>> types) {
        throw new UnsupportedOperationException("Cannot unset permission using LuckPerms API");
    }

    @Override
    public boolean isUnsetSupported() {
        return false;
    }
}

