/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.permissions;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.permissions.CosmeticPermissionGetter;
import be.isach.ultracosmetics.permissions.CosmeticPermissionSetter;
import be.isach.ultracosmetics.permissions.GrantSource;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;

public class ProfilePermissions
implements CosmeticPermissionGetter,
CosmeticPermissionSetter {
    private final UltraPlayerManager pm;

    public ProfilePermissions(UltraCosmetics ultraCosmetics) {
        this.pm = ultraCosmetics.getPlayerManager();
    }

    @Override
    public void setPermissions(Player player, Set<CosmeticType<?>> types) {
        this.pm.getUltraPlayer(player).getProfile().setUnlocked(types);
    }

    @Override
    public void unsetPermissions(Player player, Set<CosmeticType<?>> types) {
        this.pm.getUltraPlayer(player).getProfile().setLocked(types);
    }

    @Override
    public GrantSource getGrantSource(Player player, CosmeticType<?> type) {
        return this.pm.getUltraPlayer(player).getProfile().hasUnlocked(type) ? GrantSource.PROFILE : null;
    }

    @Override
    public Set<CosmeticType<?>> getEnabledUnlocked(Player player) {
        return this.pm.getUltraPlayer(player).getProfile().getAllUnlocked();
    }

    @Override
    public Set<CosmeticType<?>> getEnabledUnlocked(Player player, Category cat) {
        HashSet types = new HashSet();
        this.pm.getUltraPlayer(player).getProfile().getAllUnlocked().stream().filter(t -> t.getCategory() == cat && t.isEnabled()).forEach(types::add);
        return types;
    }

    @Override
    public boolean isUnsetSupported() {
        return true;
    }
}

