/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.player.profile;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.profile.PlayerData;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public abstract class CosmeticsProfile {
    protected final UltraPlayer ultraPlayer;
    protected final UUID uuid;
    protected final UltraCosmetics ultraCosmetics;
    protected final PlayerData data;
    protected final AtomicBoolean loaded = new AtomicBoolean();
    protected Consumer<CosmeticsProfile> onLoad = p -> {};

    public CosmeticsProfile(UltraPlayer ultraPlayer, UltraCosmetics ultraCosmetics) {
        this.ultraPlayer = ultraPlayer;
        this.uuid = ultraPlayer.getUUID();
        this.ultraCosmetics = ultraCosmetics;
        this.data = new PlayerData(this.uuid);
        ultraCosmetics.getScheduler().runAsync(outer -> {
            this.load();
            AtomicBoolean atomicBoolean = this.loaded;
            synchronized (atomicBoolean) {
                this.loaded.set(true);
                ultraCosmetics.getScheduler().runNextTick(inner -> this.onLoad.accept(this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad(Consumer<CosmeticsProfile> onLoad) {
        AtomicBoolean atomicBoolean = this.loaded;
        synchronized (atomicBoolean) {
            if (this.loaded.get()) {
                onLoad.accept(this);
                return;
            }
            this.onLoad = onLoad;
        }
    }

    protected abstract void load();

    public abstract void save();

    public void equip() {
        if (!this.ultraPlayer.isOnline()) {
            return;
        }
        if (!SettingsManager.isAllowedWorld(this.ultraPlayer.getBukkitPlayer().getWorld())) {
            return;
        }
        this.ultraPlayer.withPreserveEquipped(() -> {
            for (Map.Entry<Category, CosmeticType<?>> type : this.data.getEnabledCosmetics().entrySet()) {
                if (type.getValue() == null || !type.getKey().isEnabled() || !type.getValue().isEnabled()) continue;
                type.getValue().equip(this.ultraPlayer, this.ultraCosmetics);
            }
        });
    }

    public void setEnabledCosmetic(Category cat, Cosmetic<?> cosmetic) {
        this.setEnabledCosmetic(cat, cosmetic == null ? null : (CosmeticType<?>)cosmetic.getType());
    }

    public void setEnabledCosmetic(Category cat, CosmeticType<?> type) {
        this.data.getEnabledCosmetics().put(cat, type);
    }

    public void clearAllEquipped() {
        this.data.getEnabledCosmetics().clear();
    }

    public boolean hasAnyEquipped() {
        return !this.data.getEnabledCosmetics().isEmpty();
    }

    public int getAmmo(GadgetType gadget) {
        return this.data.getAmmo().getOrDefault(gadget, 0);
    }

    public void setAmmo(GadgetType type, int amount) {
        this.data.getAmmo().put(type, amount);
    }

    public void addAmmo(GadgetType type, int amount) {
        this.setAmmo(type, this.getAmmo(type) + amount);
    }

    public String getPetName(PetType pet) {
        return this.data.getPetNames().get(pet);
    }

    public void setPetName(PetType pet, String name) {
        this.data.getPetNames().put(pet, name);
    }

    public int getKeys() {
        return this.data.getKeys();
    }

    public void setKeys(int amount) {
        this.data.setKeys(amount);
    }

    public void addKeys(int amount) {
        this.setKeys(this.getKeys() + amount);
    }

    public void setGadgetsEnabled(boolean enabled) {
        this.data.setGadgetsEnabled(enabled);
    }

    public boolean hasGadgetsEnabled() {
        return this.data.isGadgetsEnabled();
    }

    public void setSeeSelfMorph(boolean enabled) {
        this.data.setMorphSelfView(enabled);
    }

    public boolean canSeeSelfMorph() {
        return this.data.isMorphSelfView();
    }

    public boolean isTreasureNotifications() {
        return this.data.isTreasureNotifications();
    }

    public void setTreasureNotifications(boolean treasureNotifications) {
        this.data.setTreasureNotifications(treasureNotifications);
    }

    public boolean isFilterByOwned() {
        return this.data.isFilterByOwned();
    }

    public void setFilterByOwned(boolean filterByOwned) {
        this.data.setFilterByOwned(filterByOwned);
    }

    public boolean hasUnlocked(CosmeticType<?> type) {
        return this.data.getUnlockedCosmetics().contains(type);
    }

    public void setUnlocked(Set<CosmeticType<?>> type) {
        this.data.getUnlockedCosmetics().addAll(type);
    }

    public void setLocked(Set<CosmeticType<?>> type) {
        this.data.getUnlockedCosmetics().removeAll(type);
    }

    public Set<CosmeticType<?>> getAllUnlocked() {
        return Collections.unmodifiableSet(this.data.getUnlockedCosmetics());
    }
}

