/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip;

import be.isach.ultracosmetics.shaded.mobchip.ai.animation.EntityAnimation;
import be.isach.ultracosmetics.shaded.mobchip.util.Position;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityBody {
    public boolean isLeftHanded();

    public void setLeftHanded(boolean var1);

    public boolean canBreatheUnderwater();

    public boolean shouldDiscardFriction();

    public void setDiscardFriction(boolean var1);

    public InteractionResult interact(@NotNull Player var1, @Nullable InteractionHand var2);

    public boolean isSensitiveToWater();

    public boolean isAffectedByPotions();

    public boolean isBlocking();

    public float getArmorCoverPercentage();

    public void useItem(@Nullable InteractionHand var1);

    public boolean isUsingItem();

    public boolean isFireImmune();

    public boolean isSwinging();

    public boolean canRideUnderwater();

    public boolean isInvisibleTo(@Nullable Player var1);

    @NotNull
    public InteractionHand getMainHand();

    public List<ItemStack> getDefaultDrops();

    public void setDefaultDrops(ItemStack ... var1);

    default public void setDefaultDrops(@Nullable Iterable<ItemStack> drops) {
        if (drops == null) {
            return;
        }
        this.setDefaultDrops((ItemStack[])ImmutableList.copyOf(drops).toArray((Object[])new ItemStack[0]));
    }

    default public void setDefaultDrops(Material ... drops) {
        if (drops == null) {
            return;
        }
        ItemStack[] items = new ItemStack[drops.length];
        for (int i = 0; i < drops.length; ++i) {
            items[i] = new ItemStack(drops[i]);
        }
        this.setDefaultDrops(items);
    }

    @Deprecated
    public boolean isInCombat();

    public float getFlyingSpeed();

    public void setFlyingSpeed(float var1) throws IllegalArgumentException;

    public boolean isForcingDrops();

    public void setForcingDrops(boolean var1);

    public boolean isMoving();

    public static float normalizeRotation(float rotation) {
        return rotation > 360.0f ? rotation - (float)(360.0 * Math.floor(rotation / 360.0f)) : rotation;
    }

    public float getBodyRotation();

    public void setBodyRotation(float var1);

    public float getHeadRotation();

    public void setHeadRotation(float var1);

    public float getYaw();

    public void setYaw(float var1);

    public float getPitch();

    public void setPitch(float var1);

    public Set<? extends Entity> getCollideExemptions();

    public void addCollideExemption(@NotNull Entity var1) throws IllegalArgumentException;

    default public void addCollideExemptions(Entity ... entities) throws IllegalArgumentException {
        if (entities == null) {
            throw new IllegalArgumentException("Entities cannot be null!");
        }
        this.addCollideExemptions(Arrays.asList(entities));
    }

    default public void addCollideExemptions(@NotNull Iterable<Entity> entities) throws IllegalArgumentException {
        if (entities == null) {
            throw new IllegalArgumentException("Entities cannot be null!");
        }
        for (Entity en : entities) {
            if (en == null) {
                throw new IllegalArgumentException("Collection cannot contain any null entities!");
            }
            this.addCollideExemption(en);
        }
    }

    public void removeCollideExemption(@NotNull Entity var1) throws IllegalArgumentException;

    public int getDroppedExperience();

    public void setDroppedExperience(int var1) throws IllegalArgumentException;

    public void playAnimation(@NotNull EntityAnimation var1);

    public float getAnimationSpeed();

    public void setAnimationSpeed(float var1) throws IllegalArgumentException;

    public boolean hasVerticalCollision();

    public void setVerticalCollision(boolean var1);

    public boolean hasHorizontalCollision();

    public void setHorizontalCollision(boolean var1);

    public float getWalkDistance();

    public float getMoveDistance();

    public float getFlyDistance();

    public boolean isImmuneToExplosions();

    public boolean isPeacefulCompatible();

    public boolean isInBubbleColumn();

    public boolean isInvulnerableTo(@Nullable EntityDamageEvent.DamageCause var1);

    public int getMaxFallDistance();

    public boolean isPushableBy(@Nullable Entity var1);

    @Deprecated
    public float getMaxUpStep();

    @Deprecated
    public void setMaxUpStep(float var1);

    public Position getLastLavaContact();

    public void setRiptideTicks(int var1) throws IllegalArgumentException;

    default public void stopRiptiding() {
        this.setRiptideTicks(0);
    }

    default public void addRiptideTicks(int ticks) throws IllegalArgumentException {
        if (ticks < 0) {
            throw new IllegalArgumentException("Riptiding ticks cannot be negative!");
        }
        this.setRiptideTicks(this.getRiptideTicks() + ticks);
    }

    public int getRiptideTicks();

    default public boolean isRiptiding() {
        return this.getRiptideTicks() == 0;
    }

    @NotNull
    public Mob getEntity();

    public boolean shouldRenderFrom(double var1, double var3, double var5);

    default public boolean shouldRenderFrom(@NotNull Location l) {
        if (l == null) {
            return false;
        }
        if (!this.getEntity().getWorld().getUID().equals(l.getWorld().getUID())) {
            return false;
        }
        return this.shouldRenderFrom(l.getX(), l.getY(), l.getZ());
    }

    default public boolean shouldRenderFrom(double dist) {
        return this.shouldRenderFromSqr(dist * dist);
    }

    public boolean shouldRenderFromSqr(double var1);

    public void sendTo(@NotNull Player var1) throws UnsupportedOperationException;

    public void resetFallDistance();

    public boolean isInUnloadedChunk();

    public void naturalKnockback(double var1, double var3, double var5);

    public void eat(@NotNull ItemStack var1);

    public void setRotation(float var1, float var2);

    public int getHurtTime();

    public void setHurtTime(int var1);

    public int getHurtDuration();

    public void setHurtDuration(int var1);

    public int getDeathTime();

    public void setDeathTime(int var1);

    public float getForwardSpeed();

    public void setForwardSpeed(float var1);

    public float getSidewaysSpeed();

    public void setSidewaysSpeed(float var1);

    public float getUpwardSpeed();

    public void setUpwardSpeed(float var1);

    public static enum InteractionResult {
        SUCCESS,
        CONSUME,
        CONSUME_PARTIAL,
        PASS,
        FAIL;

    }

    public static enum InteractionHand {
        MAIN_HAND,
        OFF_HAND;


        @NotNull
        public EquipmentSlot toEquipmentSlot() {
            if (this == MAIN_HAND) {
                return EquipmentSlot.HAND;
            }
            return EquipmentSlot.OFF_HAND;
        }

        @Nullable
        public static InteractionHand fromEquipmentSlot(@Nullable EquipmentSlot slot) {
            if (slot == null) {
                return null;
            }
            switch (slot) {
                case HAND: {
                    return MAIN_HAND;
                }
                case OFF_HAND: {
                    return OFF_HAND;
                }
            }
            return null;
        }
    }
}

