/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip.ai.goal;

import be.isach.ultracosmetics.shaded.mobchip.ai.SpeedModifier;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.Pathfinder;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;

public final class PathfinderRemoveBlock
extends Pathfinder
implements SpeedModifier {
    private double speedMod;
    private Material toRemove;
    private int verticalSearchRange;

    public PathfinderRemoveBlock(@NotNull Creature c2, @NotNull Block remove) {
        this(c2, remove, 1.0);
    }

    public PathfinderRemoveBlock(@NotNull Creature c2, @NotNull Block remove, double speedMod) {
        this(c2, remove, speedMod, 1);
    }

    public PathfinderRemoveBlock(@NotNull Creature c2, @NotNull Block remove, double speedMod, int verticalSearchRange) {
        super((Mob)c2);
        if (remove == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        if (!remove.getWorld().getUID().equals(c2.getWorld().getUID())) {
            throw new IllegalArgumentException("Differing worlds: Creature[" + c2.getWorld().getName() + "] not matching Block[" + remove.getWorld().getName() + "]");
        }
        if (verticalSearchRange < 1) {
            throw new IllegalArgumentException("Vertical search range must be positive");
        }
        this.toRemove = remove.getType();
        this.speedMod = speedMod;
    }

    public PathfinderRemoveBlock(@NotNull Creature c2, @NotNull Material remove) throws IllegalArgumentException {
        this(c2, remove, 1.0);
    }

    public PathfinderRemoveBlock(@NotNull Creature c2, @NotNull Material remove, double speedMod) throws IllegalArgumentException {
        this(c2, remove, speedMod, 1);
    }

    public PathfinderRemoveBlock(@NotNull Creature c2, @NotNull Material remove, double speedMod, int verticalSearchRange) throws IllegalArgumentException {
        super((Mob)c2);
        if (remove == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        if (verticalSearchRange < 1) {
            throw new IllegalArgumentException("Vertical search range must be positive");
        }
        this.toRemove = remove;
        this.speedMod = speedMod;
        this.verticalSearchRange = verticalSearchRange;
    }

    @NotNull
    public Material getBlock() {
        return this.toRemove;
    }

    public void setBlock(@NotNull Block remove) throws IllegalArgumentException {
        if (remove == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        if (!remove.getWorld().getName().equals(this.entity.getWorld().getName())) {
            throw new IllegalArgumentException("Differing worlds: Creature[" + this.entity.getWorld().getName() + "] not matching Block[" + remove.getWorld().getName() + "]");
        }
        this.setBlock(remove.getType());
    }

    public void setBlock(@NotNull Material remove) throws IllegalArgumentException {
        if (remove == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        this.toRemove = remove;
    }

    @Override
    public double getSpeedModifier() {
        return this.speedMod;
    }

    @Override
    public void setSpeedModifier(double mod) {
        this.speedMod = mod;
    }

    public int getVerticalSearchRange() {
        return this.verticalSearchRange;
    }

    public void setVerticalSearchRange(int verticalSearchRange) {
        this.verticalSearchRange = verticalSearchRange;
    }

    @Override
    @NotNull
    public Pathfinder.PathfinderFlag[] getFlags() {
        return new Pathfinder.PathfinderFlag[0];
    }

    @Override
    public String getInternalName() {
        return "PathfinderGoalRemoveBlock";
    }
}

