/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip.ai.goal.target;

import be.isach.ultracosmetics.shaded.mobchip.ai.goal.Conditional;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.Pathfinder;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.Repeated;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.target.Filtering;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.target.TargetPathfinder;
import java.util.function.Predicate;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathfinderNearestAttackableTarget<T extends LivingEntity>
extends TargetPathfinder
implements Filtering<T>,
Conditional<LivingEntity>,
Repeated {
    private Class<T> filter;
    private Predicate<LivingEntity> conditions;
    private int interval;

    public PathfinderNearestAttackableTarget(@NotNull Mob m, @NotNull Class<T> filter) throws IllegalArgumentException {
        this(m, filter, 10);
    }

    public PathfinderNearestAttackableTarget(@NotNull Mob m, @NotNull Class<T> filter, int interval) throws IllegalArgumentException {
        this(m, filter, interval, true, true);
    }

    public PathfinderNearestAttackableTarget(@NotNull Mob m, @NotNull Class<T> filter, int interval, boolean mustSee, boolean reach) throws IllegalArgumentException {
        this(m, filter, interval, mustSee, reach, null);
    }

    public PathfinderNearestAttackableTarget(@NotNull Mob m, @NotNull Class<T> filter, int interval, boolean mustSee, boolean reach, @Nullable Predicate<LivingEntity> conditions) throws IllegalArgumentException {
        super(m, mustSee, reach);
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        this.filter = filter;
        this.interval = interval;
        this.conditions = conditions == null ? e -> true : conditions;
    }

    @Override
    public void setFilter(@NotNull Class<T> clazz) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz cannot be null");
        }
        this.filter = clazz;
    }

    @Override
    public Class<T> getFilter() {
        return this.filter;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(int interval) throws IllegalArgumentException {
        if (interval < 1) {
            throw new IllegalArgumentException("Must be greater than 0");
        }
        this.interval = interval;
    }

    @Override
    @NotNull
    public Predicate<LivingEntity> getCondition() {
        return this.conditions;
    }

    @Override
    public void setCondition(@NotNull Predicate<LivingEntity> condition) {
        this.conditions = condition;
    }

    @Override
    @NotNull
    public Pathfinder.PathfinderFlag[] getFlags() {
        return new Pathfinder.PathfinderFlag[]{Pathfinder.PathfinderFlag.TARGETING};
    }

    @Override
    public String getInternalName() {
        return "PathfinderGoalNearestAttackableTarget";
    }
}

