/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip.combat;

import be.isach.ultracosmetics.shaded.mobchip.combat.CombatLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CombatEntry {
    private final Mob owner;
    private final EntityDamageEvent.DamageCause cause;
    private final int ticks;
    private final float health;
    private final float damage;
    private final CombatLocation location;
    private final float lastFallDistance;
    private final Entity attacker;

    private CombatEntry(@NotNull Builder builder) {
        this.owner = builder.owner;
        this.cause = builder.cause;
        this.ticks = builder.ticks;
        this.health = builder.health;
        this.damage = builder.damage;
        this.location = builder.location;
        this.lastFallDistance = builder.fall;
        this.attacker = builder.attacker;
    }

    public CombatEntry(@NotNull Mob owner, @NotNull EntityDamageEvent.DamageCause cause, int ticks, float health, float damage) throws IllegalArgumentException {
        this(owner, cause, ticks, health, damage, 0.0f);
    }

    public CombatEntry(@NotNull Mob owner, @NotNull EntityDamageEvent.DamageCause cause, int ticks, float health, float damage, float fall) throws IllegalArgumentException {
        this(owner, cause, ticks, health, damage, fall, null);
    }

    public CombatEntry(@NotNull Mob owner, @NotNull EntityDamageEvent.DamageCause cause, int ticks, float health, float damage, float fall, @Nullable CombatLocation combatLocation) throws IllegalArgumentException {
        this(owner, cause, ticks, health, damage, fall, combatLocation, null);
    }

    public CombatEntry(@NotNull Mob owner, @NotNull EntityDamageEvent.DamageCause cause, int ticks, float health, float damage, float fall, @Nullable CombatLocation combatLocation, @Nullable Entity attacker) throws IllegalArgumentException {
        if (cause == null) {
            throw new IllegalArgumentException("DamageCause cannot be null");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Owner of CombatEntry cannot be null");
        }
        if (ticks < 0 || health < 0.0f || damage < 0.0f || fall < 0.0f) {
            throw new IllegalArgumentException("Ticks, Health, Damage Amount, and Fall Damage cannot be less than 0");
        }
        this.owner = owner;
        this.cause = cause;
        this.ticks = ticks;
        this.health = health;
        this.damage = damage;
        this.location = combatLocation;
        this.lastFallDistance = fall;
        this.attacker = attacker;
    }

    @NotNull
    public EntityDamageEvent.DamageCause getCause() {
        return this.cause;
    }

    @Deprecated
    public int getCombatTime() {
        return this.ticks;
    }

    @NotNull
    public Mob getOwner() {
        return this.owner;
    }

    public float getDamage() {
        return this.damage;
    }

    @Deprecated
    public float getHealthBeforeDamage() {
        return this.health;
    }

    public float getHealthAfterDamage() {
        return this.health - this.damage;
    }

    @Nullable
    public CombatLocation getLocation() {
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    @Deprecated
    @Nullable
    public Entity getAttacker() {
        return this.attacker;
    }

    public boolean hasAttacker() {
        return this.attacker != null;
    }

    public float getFallDistance() {
        return this.lastFallDistance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        Mob owner;
        EntityDamageEvent.DamageCause cause;
        int ticks;
        float health;
        float damage;
        CombatLocation location;
        float fall;
        Entity attacker;

        Builder() {
        }

        @NotNull
        public Builder setOwner(@NotNull Mob owner) throws IllegalArgumentException {
            if (owner == null) {
                throw new IllegalArgumentException("Owner of CombatEntry cannot be null");
            }
            this.owner = owner;
            return this;
        }

        @NotNull
        public Builder setCause(@NotNull EntityDamageEvent.DamageCause cause) throws IllegalArgumentException {
            if (cause == null) {
                throw new IllegalArgumentException("DamageCause cannot be null");
            }
            this.cause = cause;
            return this;
        }

        @NotNull
        public Builder setCombatDuration(int ticks) throws IllegalArgumentException {
            if (ticks < 0) {
                throw new IllegalArgumentException("Combat Duration cannot be less than 0");
            }
            this.ticks = ticks;
            return this;
        }

        @NotNull
        public Builder setHealthBeforeDamage(float health) throws IllegalArgumentException {
            if (health < 0.0f) {
                throw new IllegalArgumentException("Health cannot be less than 0");
            }
            this.health = health;
            return this;
        }

        @NotNull
        public Builder setDamage(float damage) throws IllegalArgumentException {
            if (damage < 0.0f) {
                throw new IllegalArgumentException("Damage cannot be less than 0");
            }
            this.damage = damage;
            return this;
        }

        @NotNull
        public Builder setLocation(@Nullable CombatLocation location) {
            this.location = location;
            return this;
        }

        @NotNull
        public Builder setFallDistance(float fall) throws IllegalArgumentException {
            if (fall < 0.0f) {
                throw new IllegalArgumentException("Fall Distance cannot be less than 0");
            }
            this.fall = fall;
            return this;
        }

        @NotNull
        public Builder setAttacker(@Nullable Entity attacker) {
            this.attacker = attacker;
            return this;
        }

        @NotNull
        public CombatEntry build() throws IllegalStateException {
            if (this.owner == null) {
                throw new IllegalStateException("Owner of CombatEntry cannot be null");
            }
            if (this.cause == null) {
                throw new IllegalStateException("DamageCause cannot be null");
            }
            if (this.ticks < 0) {
                throw new IllegalStateException("Combat Duration cannot be less than 0");
            }
            if (this.health < 0.0f) {
                throw new IllegalStateException("Health cannot be less than 0");
            }
            if (this.damage < 0.0f) {
                throw new IllegalStateException("Damage cannot be less than 0");
            }
            if (this.fall < 0.0f) {
                throw new IllegalStateException("Fall Distance cannot be less than 0");
            }
            return new CombatEntry(this);
        }
    }
}

