/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.task.UltraTask;
import be.isach.ultracosmetics.treasurechests.ChestParticleRunnable;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import com.cryptomorin.xseries.XBlock;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class PlaceChestRunnable
extends UltraTask {
    private static final ParticleDisplay SMOKE = ParticleDisplay.of((XParticle)XParticle.LARGE_SMOKE).withCount(5);
    private static final ParticleDisplay LAVA = ParticleDisplay.of((XParticle)XParticle.LAVA).withCount(5);
    private final TreasureChest chest;
    private final Block chestBlock;
    private final int direction;
    private final XSound.SoundPlayer sound;
    private final int animationTime;

    public PlaceChestRunnable(TreasureChest chest, Block chestBlock, int direction, int animationTime) {
        this.chest = chest;
        this.chestBlock = chestBlock;
        this.direction = direction;
        this.animationTime = animationTime;
        this.sound = XSound.BLOCK_ANVIL_LAND.record().withVolume(1.4f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{chest.getPlayer()});
    }

    @Override
    public void run() {
        this.chest.addChest(this.chestBlock, this.chest.getDesign().getChestType().getType());
        this.sound.play();
        SMOKE.spawn(this.chestBlock.getLocation());
        LAVA.spawn(this.chestBlock.getLocation());
        XBlock.setDirection((Block)this.chestBlock, (BlockFace)ChestParticleRunnable.getDirection(this.direction).getOppositeFace());
    }

    @Override
    public void schedule() {
        this.task = this.getScheduler().runAtLocationLater(this.chestBlock.getLocation(), this::run, (long)this.animationTime);
    }
}

