/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.util.BlockViewUpdater;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.util.StructureRollback;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;

public class BlockUtils {
    private static final Set<Material> badMaterials = new HashSet<Material>();
    private static final Set<Material> AIRS = new HashSet<Material>();

    public static List<Block> getBlocksInRadius(Location location, int radius, boolean hollow) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int bX = location.getBlockX();
        int bY = location.getBlockY();
        int bZ = location.getBlockZ();
        for (int x = bX - radius; x <= bX + radius; ++x) {
            for (int y = bY - radius; y <= bY + radius; ++y) {
                for (int z = bZ - radius; z <= bZ + radius; ++z) {
                    Location l;
                    double distance = (bX - x) * (bX - x) + (bY - y) * (bY - y) + (bZ - z) * (bZ - z);
                    if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1)) || (l = new Location(location.getWorld(), (double)x, (double)y, (double)z)).getBlock().getType() == Material.BARRIER) continue;
                    blocks.add(l.getBlock());
                }
            }
        }
        return blocks;
    }

    public static boolean isOnGround(Entity entity) {
        Block block = entity.getLocation().getBlock().getRelative(BlockFace.DOWN);
        return block.getType().isSolid();
    }

    public static boolean isRestoring(Block block) {
        return BlockViewUpdater.isUpdating(block);
    }

    public static void setToRestoreIgnoring(Map<Block, XMaterial> blocks, int tickDelay) {
        UltraCosmeticsData.get().getPlugin().getScheduler().runAsync(task -> {
            blocks.keySet().removeIf(BlockViewUpdater::isUpdating);
            if (blocks.isEmpty()) {
                return;
            }
            World world = ((Block)blocks.keySet().iterator().next()).getWorld();
            for (Map.Entry entry : blocks.entrySet()) {
                BlockData data = Bukkit.createBlockData((Material)((XMaterial)entry.getValue()).get());
                for (Player player : world.getPlayers()) {
                    player.sendBlockChange(((Block)entry.getKey()).getLocation(), data);
                }
            }
            new BlockViewUpdater(blocks.keySet(), tickDelay).schedule();
        });
    }

    public static void setToRestore(Map<Block, XMaterial> blocks, int tickDelay) {
        blocks.keySet().removeIf(b -> !BlockUtils.canRestore(b));
        BlockUtils.setToRestoreIgnoring(blocks, tickDelay);
    }

    public static boolean canRestore(Block block) {
        return !badMaterials.contains(block.getType()) && !SettingsManager.getConfig().getStringList("Gadgets.PaintballGun.BlackList").contains(block.getType().name()) && !BlockUtils.isPortalBlock(block) && !StructureRollback.isBlockRollingBack(block) && block.getType().isSolid() && BlockUtils.okAboveBlock(block.getRelative(BlockFace.UP).getType());
    }

    private static boolean okAboveBlock(Material mat) {
        return BlockUtils.isAir(mat) || mat.isSolid();
    }

    public static boolean isPortalBlock(Block b) {
        for (BlockFace face : BlockFace.values()) {
            if (b.getRelative(face).getType() != XMaterial.NETHER_PORTAL.get()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBadMaterial(Material mat) {
        return badMaterials.contains(mat);
    }

    public static boolean isAir(Material mat) {
        return AIRS.contains(mat);
    }

    public static FallingBlock spawnFallingBlock(Location loc, Material type) {
        return loc.getWorld().spawnFallingBlock(loc, type.createBlockData());
    }

    public static FallingBlock spawnFallingBlock(Location loc, Block source) {
        return loc.getWorld().spawnFallingBlock(loc, source.getBlockData());
    }

    static {
        for (String name : SettingsManager.getConfig().getStringList("Air-Materials")) {
            Optional optional = XMaterial.matchXMaterial((String)name);
            if (!optional.isPresent()) {
                UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Failed to parse 'Air-Materials' item: " + name);
                continue;
            }
            Material parsed = ((XMaterial)optional.get()).get();
            if (parsed == null) continue;
            AIRS.add(parsed);
        }
        HashSet<XMaterial> badXMaterials = new HashSet<XMaterial>();
        badXMaterials.add(XMaterial.CHEST);
        badXMaterials.add(XMaterial.ENDER_CHEST);
        badXMaterials.add(XMaterial.WHEAT);
        badXMaterials.add(XMaterial.SHORT_GRASS);
        badXMaterials.add(XMaterial.DEAD_BUSH);
        badXMaterials.add(XMaterial.POPPY);
        badXMaterials.add(XMaterial.RED_MUSHROOM);
        badXMaterials.add(XMaterial.BROWN_MUSHROOM);
        badXMaterials.add(XMaterial.TORCH);
        badXMaterials.add(XMaterial.LADDER);
        badXMaterials.add(XMaterial.VINE);
        badXMaterials.add(XMaterial.LARGE_FERN);
        badXMaterials.add(XMaterial.LILAC);
        badXMaterials.add(XMaterial.PEONY);
        badXMaterials.add(XMaterial.ROSE_BUSH);
        badXMaterials.add(XMaterial.SUNFLOWER);
        badXMaterials.add(XMaterial.NETHER_PORTAL);
        badXMaterials.add(XMaterial.CACTUS);
        badXMaterials.add(XMaterial.WATER);
        badXMaterials.add(XMaterial.LAVA);
        badXMaterials.add(XMaterial.END_PORTAL);
        badXMaterials.add(XMaterial.FARMLAND);
        badXMaterials.add(XMaterial.BARRIER);
        badXMaterials.add(XMaterial.COMMAND_BLOCK);
        badXMaterials.add(XMaterial.DROPPER);
        badXMaterials.add(XMaterial.DISPENSER);
        badXMaterials.addAll(XTag.WOODEN_SLABS.getValues());
        badXMaterials.addAll(XTag.NON_WOODEN_SLABS.getValues());
        badXMaterials.addAll(XTag.DOORS.getValues());
        badXMaterials.addAll(XTag.SIGNS.getValues());
        badXMaterials.addAll(XTag.BEDS.getValues());
        badXMaterials.addAll(XTag.PRESSURE_PLATES.getValues());
        badXMaterials.addAll(XTag.BANNERS.getValues());
        badXMaterials.addAll(XTag.SAPLINGS.getValues());
        for (XMaterial xMaterial : badXMaterials) {
            badMaterials.add(xMaterial.get());
        }
        badMaterials.addAll(AIRS);
    }
}

