/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import java.awt.Color;

public class ColorUtils {
    public static Color getRainbowColor() {
        return ColorUtils.getRainbowColor(2.0);
    }

    public static Color getRainbowColor(double secondsPerPhase) {
        long currentEpochMilliseconds = System.currentTimeMillis();
        long currentEpochSeconds = currentEpochMilliseconds / 1000L;
        int phase = (int)((double)currentEpochSeconds % (6.0 * secondsPerPhase) / secondsPerPhase);
        double millisecondsToAdjustBy = (double)currentEpochMilliseconds % (secondsPerPhase * 1000.0);
        int currentRotatingRgbValue = (int)(millisecondsToAdjustBy * 0.255 / secondsPerPhase);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (phase == 0) {
            red = 255;
            green = currentRotatingRgbValue;
        } else if (phase == 1) {
            red = 255 - currentRotatingRgbValue;
            green = 255;
        } else if (phase == 2) {
            green = 255;
            blue = currentRotatingRgbValue;
        } else if (phase == 3) {
            green = 255 - currentRotatingRgbValue;
            blue = 255;
        } else if (phase == 4) {
            red = currentRotatingRgbValue;
            blue = 255;
        } else if (phase == 5) {
            red = 255;
            blue = 255 - currentRotatingRgbValue;
        }
        return new Color(red, green, blue);
    }
}

