/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.shaded.mobchip.EntityBrain;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.CustomPathfinder;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.Pathfinder;
import be.isach.ultracosmetics.shaded.mobchip.bukkit.BukkitBrain;
import com.cryptomorin.xseries.XEntityType;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.util.Vector;

public class PetPathfinder
extends CustomPathfinder {
    private final Player target;
    private final EntityBrain brain;
    private final double maxRange;
    private final double tpRange;
    private final double yOffset;
    private final double speed;
    private final boolean useEyeLocation;
    private boolean stopped = false;

    public PetPathfinder(Mob mob, Player target, double maxRange, double tpRange, double yOffset) {
        super(mob);
        this.target = target;
        this.brain = BukkitBrain.getBrain(mob);
        this.maxRange = maxRange;
        this.tpRange = tpRange;
        this.yOffset = yOffset;
        double speed = 1.15;
        boolean useEyeLocation = false;
        if (mob.getType() == EntityType.VEX) {
            speed = 0.75;
            useEyeLocation = true;
        } else if (mob instanceof Slime) {
            speed = 2.5;
        }
        this.speed = speed;
        this.useEyeLocation = useEyeLocation;
    }

    public PetPathfinder(Mob mob, Player target) {
        this(mob, target, 3.0, 10.0, 0.0);
    }

    @Override
    public boolean canStart() {
        return true;
    }

    @Override
    public Pathfinder.PathfinderFlag[] getFlags() {
        return new Pathfinder.PathfinderFlag[]{Pathfinder.PathfinderFlag.MOVEMENT, Pathfinder.PathfinderFlag.JUMPING};
    }

    @Override
    public void start() {
    }

    @Override
    public void tick() {
        Location targetLoc = this.useEyeLocation ? this.target.getEyeLocation() : this.target.getLocation();
        Location ourLoc = this.entity.getLocation().add(0.0, this.yOffset, 0.0);
        if (ourLoc.getWorld() != targetLoc.getWorld()) {
            return;
        }
        if (this.entity instanceof Slime) {
            Location deltaLoc = ourLoc.clone().subtract(targetLoc);
            double direction = -Math.atan2(deltaLoc.getX(), deltaLoc.getZ());
            float degrees = (float)(Math.toDegrees(direction) + 180.0);
            this.brain.getBody().setRotation(degrees, 0.0f);
        }
        if (this.entity.isLeashed()) {
            return;
        }
        double distSquared = ourLoc.distanceSquared(targetLoc);
        if (distSquared > this.tpRange * this.tpRange) {
            UltraCosmeticsData.get().getPlugin().getScheduler().teleportAsync((Entity)this.entity, targetLoc);
            this.brain.getController().moveTo(targetLoc.subtract(0.0, this.yOffset, 0.0), this.speed);
            return;
        }
        if (distSquared > this.maxRange * this.maxRange) {
            Vector direction = targetLoc.clone().subtract(ourLoc).toVector().normalize().multiply(0.5);
            this.brain.getController().moveTo(targetLoc.subtract(direction).subtract(0.0, this.yOffset, 0.0), this.speed);
        } else if (this.entity.getType() == XEntityType.HAPPY_GHAST.get()) {
            Location loc = ourLoc.add(ourLoc.subtract(targetLoc).toVector());
            this.brain.getController().moveTo(loc.subtract(0.0, this.yOffset, 0.0), 0.0);
        }
    }
}

