/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private final String version;
    private final String classifier;
    private final String gitHash;

    public Version(String version, String gitHash) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        this.version = Version.findVersion(version);
        this.classifier = Version.findClassifier(version);
        this.gitHash = gitHash;
    }

    public Version(String version) {
        this(version, null);
    }

    private static String findVersion(String version) {
        Matcher matcher = Pattern.compile("\\d+(?:\\.\\d+)+").matcher(version);
        matcher.find();
        return matcher.group();
    }

    private static String findClassifier(String version) {
        if (!version.contains("-")) {
            return "RELEASE";
        }
        return version.split("-", 2)[1];
    }

    public final String numbersOnly() {
        return this.version;
    }

    public String versionWithClassifier() {
        return this.version + "-" + this.classifier;
    }

    public String versionClassifierCommit() {
        StringBuilder builder = new StringBuilder(this.version);
        builder.append('-').append(this.classifier);
        if (this.gitHash != null) {
            builder.append(" (commit ").append(this.gitHash).append(')');
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Version otherVersion) {
        String[] thisParts = this.numbersOnly().split("\\.");
        String[] thatParts = otherVersion.numbersOnly().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int cmp = Integer.compare(thisPart, thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0);
            if (cmp == 0) continue;
            return cmp;
        }
        return Boolean.compare(this.isRelease(), otherVersion.isRelease());
    }

    public boolean isDev() {
        return this.classifier.toLowerCase(Locale.ROOT).contains("dev");
    }

    public boolean isRelease() {
        return !this.isDev();
    }

    public boolean equals(Object that) {
        return this == that || that != null && this.getClass() == that.getClass() && this.compareTo((Version)that) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.numbersOnly();
    }
}

