/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.v1_21_R6.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.task.UltraTask;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.v1_21_R6.VersionModule;
import be.isach.ultracosmetics.v1_21_R6.customentities.CustomEntities;
import be.isach.ultracosmetics.v1_21_R6.customentities.CustomGuardian;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.level.World;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class MorphElderGuardian
extends Morph
implements Updatable {
    private boolean cooldown;
    private CustomGuardian customGuardian;

    public MorphElderGuardian(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (!(event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK || this.cooldown || event.getPlayer() != this.getPlayer())) {
            this.shootLaser();
            this.cooldown = true;
            UltraTask.runLater(() -> {
                this.cooldown = false;
            }, 80L);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (((CraftEntity)event.getDamager()).getHandle() == this.customGuardian && event.getEntity() == this.getPlayer()) {
            event.setCancelled(true);
        }
    }

    private void shootLaser() {
        if (this.customGuardian == null) {
            return;
        }
        Location FROM = this.customGuardian.getBukkitEntity().getLocation();
        Location TO = FROM.clone().add(this.getPlayer().getLocation().getDirection().multiply(10));
        ArmorStand armorStand = (ArmorStand)this.getPlayer().getWorld().spawn(TO, ArmorStand.class);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setSmall(true);
        this.customGuardian.target(armorStand);
        UltraTask.runAtLocationLater(FROM, () -> {
            FireworkEffect.Builder builder = FireworkEffect.builder();
            FireworkEffect effect = builder.flicker(false).trail(false).with(FireworkEffect.Type.BALL_LARGE).withColor(Color.TEAL).withFade(Color.TEAL).build();
            VersionModule.spawnFirework_(TO, effect, new Player[0]);
            Vector vector = TO.toVector().subtract(FROM.toVector());
            Location current = FROM.clone();
            for (int i = 0; i < 10; ++i) {
                for (Entity entity : current.getWorld().getNearbyEntities(current, 4.5, 4.5, 4.5)) {
                    if (!(entity instanceof LivingEntity) || entity == this.getPlayer()) continue;
                    MathUtils.applyVelocity(entity, new Vector(0.0, 0.5, 0.0));
                }
                current.add(vector);
            }
            armorStand.remove();
            this.customGuardian.target(null);
        }, 25L);
    }

    @Override
    public void onClear() {
        if (this.customGuardian == null) {
            return;
        }
        CustomEntities.removeCustomEntity((net.minecraft.world.entity.Entity)this.customGuardian);
    }

    @Override
    protected void onEquip() {
        super.onEquip();
        this.customGuardian = new CustomGuardian((EntityTypes<? extends EntityGuardian>)EntityTypes.P, (World)((CraftWorld)this.getPlayer().getWorld()).getHandle());
        EntitySpawningManager.withBypass(() -> CustomEntities.spawnEntity((net.minecraft.world.entity.Entity)this.customGuardian, this.getPlayer().getLocation()));
        this.getPlayer().addPassenger((Entity)this.customGuardian.getBukkitEntity());
        this.customGuardian.l(true);
    }

    @Override
    public void onUpdate() {
        if (this.getOwner() == null || this.getPlayer() == null) {
            this.cancelTask();
            return;
        }
        if (this.customGuardian == null || !this.customGuardian.bX()) {
            this.getOwner().removeCosmetic(Category.MORPHS);
            this.cancelTask();
        }
    }
}

