/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.version;

import org.bukkit.Bukkit;

public enum ServerVersion {
    v1_17(17, 1),
    v1_18(18, 2),
    v1_19(19, 4),
    v1_20(20, 6, "ee13f98a43b9c5abffdcc0bb24154460", 4),
    v1_21(21, 10, "614efe5192cd0510bc2ddc5feefa155d", 6),
    NEW("???");

    private final String name;
    private final int majorVer;
    private final int minorVer;
    private final String mappingsVersion;
    private final int nmsRevision;

    private ServerVersion(String name) {
        this.name = name;
        this.majorVer = 0;
        this.minorVer = 0;
        this.mappingsVersion = null;
        this.nmsRevision = 0;
    }

    private ServerVersion(int majorVer, int minorVer) {
        this(majorVer, minorVer, null, 0);
    }

    private ServerVersion(int majorVer, int minorVer, String mappingsVersion, int nmsRevision) {
        this.name = "1." + majorVer + (String)(minorVer > 0 ? "." + minorVer : "");
        this.majorVer = majorVer;
        this.minorVer = minorVer;
        this.mappingsVersion = mappingsVersion;
        this.nmsRevision = nmsRevision;
    }

    public String getName() {
        return this.name;
    }

    public int getMajorVer() {
        return this.majorVer;
    }

    public int getMinorVer() {
        return this.minorVer;
    }

    public String getMappingsVersion() {
        return this.mappingsVersion;
    }

    public int getNMSRevision() {
        return this.nmsRevision;
    }

    public static ServerVersion earliest() {
        return ServerVersion.values()[0];
    }

    public static ServerVersion byId(int id) {
        if (id == 0) {
            return null;
        }
        for (ServerVersion version : ServerVersion.values()) {
            if (id != version.majorVer) continue;
            return version;
        }
        return null;
    }

    public boolean isAtLeast(ServerVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isNmsSupported() {
        return this.nmsRevision > 0;
    }

    public String getNmsVersion() {
        return this.toString() + "_R" + this.nmsRevision;
    }

    public static String getMinecraftVersion() {
        String rawVersion = Bukkit.getVersion();
        return rawVersion.substring(rawVersion.lastIndexOf(" ") + 1, rawVersion.length() - 1);
    }

    public static boolean isMobchipEdgeCase() {
        return ServerVersion.getMinecraftVersion().equals("1.19");
    }

    public static ServerVersion latest() {
        return ServerVersion.values()[ServerVersion.values().length - 2];
    }
}

