/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.version;

import be.isach.ultracosmetics.version.IEntityUtil;
import be.isach.ultracosmetics.version.IModule;
import be.isach.ultracosmetics.version.ServerVersion;
import be.isach.ultracosmetics.version.dummy.DummyEntityUtil;
import be.isach.ultracosmetics.version.dummy.DummyModule;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.World;

public class VersionManager {
    public static final String PACKAGE = "be.isach.ultracosmetics";
    private static final Map<UUID, Integer> WORLD_MIN_HEIGHTS = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> WORLD_MAX_HEIGHTS = new HashMap<UUID, Integer>();
    private final ServerVersion serverVersion;
    private final boolean useNMS;
    private final IModule module;
    private final IEntityUtil entityUtil;

    public VersionManager(ServerVersion serverVersion, boolean useNMS) throws ReflectiveOperationException {
        this.serverVersion = serverVersion;
        this.useNMS = useNMS;
        if (useNMS) {
            this.module = (IModule)this.loadModule("VersionModule");
            this.entityUtil = (IEntityUtil)this.loadModule("EntityUtil");
        } else {
            this.module = new DummyModule();
            this.entityUtil = new DummyEntityUtil();
        }
    }

    private <T> T loadModule(String name) throws ReflectiveOperationException {
        return (T)Class.forName("be.isach.ultracosmetics." + this.serverVersion.getNmsVersion() + "." + name).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public IEntityUtil getEntityUtil() {
        return this.entityUtil;
    }

    public IModule getModule() {
        return this.module;
    }

    public boolean isUsingNMS() {
        return this.useNMS;
    }

    public static int getWorldMinHeight(World world) {
        return WORLD_MIN_HEIGHTS.computeIfAbsent(world.getUID(), w -> {
            try {
                return world.getMinHeight();
            }
            catch (NoSuchMethodError ex) {
                return 0;
            }
        });
    }

    public static int getWorldMaxHeight(World world) {
        return WORLD_MAX_HEIGHTS.computeIfAbsent(world.getUID(), w -> {
            try {
                return world.getMaxHeight();
            }
            catch (NoSuchMethodError ex) {
                return 255;
            }
        });
    }
}

