/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.TextComponent;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.NamedTextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextDecoration;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public abstract class SubCommand {
    private final String name;
    private final String description;
    private final Permission permission;
    private final String usage;
    private final boolean defaultPerm;
    protected final UltraCosmetics ultraCosmetics;

    public SubCommand(String name, String description, String usage, UltraCosmetics ultraCosmetics) {
        this(name, description, usage, ultraCosmetics, false);
    }

    public SubCommand(String name, String description, String usage, UltraCosmetics ultraCosmetics, boolean defaultPerm) {
        this.name = name;
        this.description = description;
        this.permission = this.registerPermission("ultracosmetics.command." + name, defaultPerm);
        this.usage = "/uc " + name + " " + usage;
        this.defaultPerm = defaultPerm;
        this.ultraCosmetics = ultraCosmetics;
    }

    public boolean is(String arg) {
        return this.name.equalsIgnoreCase(arg);
    }

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getDescription() {
        return this.description;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean isDefault() {
        return this.defaultPerm;
    }

    private Permission registerPermission(String strPerm, boolean defaultPerm) {
        Permission perm = new Permission(strPerm);
        try {
            Bukkit.getPluginManager().addPermission(perm);
        }
        catch (IllegalArgumentException e) {
            return Bukkit.getPluginManager().getPermission(strPerm);
        }
        perm.setDefault(defaultPerm ? PermissionDefault.TRUE : PermissionDefault.OP);
        return perm;
    }

    protected void onExePlayer(Player sender, String[] args) {
        this.onExeAnyone((CommandSender)sender, args);
    }

    protected abstract void onExeAnyone(CommandSender var1, String[] var2);

    protected void tabComplete(CommandSender sender, String[] args, List<String> options) {
    }

    protected void addCategories(List<String> options) {
        for (Category category : Category.enabled()) {
            options.add(category.toString());
        }
    }

    protected void addPlayers(List<String> options) {
        Bukkit.getOnlinePlayers().forEach(p -> options.add(p.getName()));
    }

    protected void notAllowed(CommandSender commandSender) {
        MessageManager.send(commandSender, "Not-Allowed-From-Console", new TagResolver.Single[0]);
    }

    protected void badUsage(CommandSender sender) {
        this.badUsage(sender, this.getUsage());
    }

    protected void badUsage(CommandSender sender, String usage) {
        this.error(sender, "Incorrect Usage. " + usage);
    }

    protected void error(CommandSender sender, String error) {
        MessageManager.getAudiences().sender(sender).sendMessage(((TextComponent)((TextComponent)Component.empty().append(MessageManager.getMessage("Prefix", new TagResolver.Single[0]))).appendSpace()).append(Component.text(error, (TextColor)NamedTextColor.RED, TextDecoration.BOLD)));
    }
}

