/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.CommandManager;
import be.isach.ultracosmetics.command.SubCommand;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class SubCommandHelp
extends SubCommand {
    private final CommandManager commandManager;

    public SubCommandHelp(UltraCosmetics ultraCosmetics, CommandManager commandManager) {
        super("help", "Shows available UltraCosmetics commands", "", ultraCosmetics);
        this.commandManager = commandManager;
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        if (args.length > 1) {
            try {
                this.showHelp(sender, Math.min(Integer.parseInt(args[1]), this.getMaxPages(this.commandManager.getCommands().size())));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.showHelp(sender, 1);
    }

    public void showHelp(CommandSender sender, int page) {
        ArrayList available = new ArrayList();
        this.commandManager.getCommands().stream().filter(c -> sender.hasPermission(c.getPermission())).forEach(available::add);
        if (available.isEmpty()) {
            CommandManager.sendNoPermissionMessage(sender);
            return;
        }
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "UltraCosmetics Help (/uc <page>) " + String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "(" + page + "/" + this.getMaxPages(available.size()) + ")");
        int from = 8 * (page - 1);
        int to = 8 * page;
        for (int i = from; i < to && i < available.size(); ++i) {
            SubCommand sub = (SubCommand)available.get(i);
            sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "|  " + String.valueOf(ChatColor.GRAY) + sub.getUsage() + String.valueOf(ChatColor.WHITE) + " " + String.valueOf(ChatColor.ITALIC) + sub.getDescription());
        }
    }

    private int getMaxPages(int commands) {
        int max = 8;
        return (commands - 1) / max + 1;
    }
}

