/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.menu.Menus;
import be.isach.ultracosmetics.menu.buttons.RenamePetButton;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandMenu
extends SubCommand {
    public SubCommandMenu(UltraCosmetics ultraCosmetics) {
        super("menu", "Opens Specified Menu", "<menu> [page] [player]", ultraCosmetics, true);
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        String s;
        Player player;
        if (args.length > 3) {
            player = Bukkit.getPlayer((String)args[3]);
            if (player == null) {
                this.error(sender, "Player not found");
                return;
            }
        } else {
            if (!(sender instanceof Player)) {
                this.error(sender, "You must specify a player");
                return;
            }
            player = (Player)sender;
        }
        if (!SettingsManager.isAllowedWorld(player.getWorld())) {
            MessageManager.send(sender, "World-Disabled", new TagResolver.Single[0]);
            return;
        }
        Menus menus = this.ultraCosmetics.getMenus();
        UltraPlayer ultraPlayer = this.ultraCosmetics.getPlayerManager().getUltraPlayer(player);
        if (args.length < 2) {
            menus.openMainMenu(ultraPlayer);
            return;
        }
        int page = 1;
        if (args.length > 2 && MathUtils.isInteger(args[2])) {
            page = Integer.parseInt(args[2]);
        }
        if ((s = args[1].toLowerCase(Locale.ROOT)).startsWith("ma")) {
            menus.openMainMenu(ultraPlayer);
            return;
        }
        if (s.startsWith("r") && SettingsManager.getConfig().getBoolean("Pets-Rename.Enabled")) {
            if (SettingsManager.getConfig().getBoolean("Pets-Rename.Permission-Required") && !sender.hasPermission("ultracosmetics.pets.rename")) {
                this.error(sender, "You don't have permission.");
                return;
            }
            if (ultraPlayer.getCurrentPet() == null) {
                MessageManager.send(sender, "Active-Pet-Needed", new TagResolver.Single[0]);
                return;
            }
            RenamePetButton.renamePet(this.ultraCosmetics, ultraPlayer, menus.getCategoryMenu(Category.PETS));
            return;
        }
        if (s.startsWith("b") && UltraCosmeticsData.get().areTreasureChestsEnabled()) {
            menus.openKeyPurchaseMenu(ultraPlayer);
            return;
        }
        Category cat = s.startsWith("s") ? Category.SUITS_HELMET : Category.fromString(s);
        if (cat == null) {
            this.sendMenuList(sender);
            return;
        }
        if (!cat.isEnabled()) {
            this.error(sender, "That menu is disabled.");
            return;
        }
        menus.getCategoryMenu(cat).open(ultraPlayer, page);
    }

    private List<String> getMenus() {
        ArrayList<String> menuList = new ArrayList<String>();
        menuList.add("main");
        if (UltraCosmeticsData.get().areTreasureChestsEnabled()) {
            menuList.add("buykey");
        }
        if (SettingsManager.getConfig().getBoolean("Pets-Rename.Enabled")) {
            menuList.add("renamepet");
        }
        boolean suits = false;
        for (Category category : Category.enabled()) {
            if (category.isSuits()) {
                if (suits) continue;
                suits = true;
                menuList.add("suits");
                continue;
            }
            menuList.add(category.name().toLowerCase(Locale.ROOT));
        }
        return menuList;
    }

    private void sendMenuList(CommandSender sender) {
        this.error(sender, "Invalid menu, available menus are:");
        this.error(sender, String.join((CharSequence)", ", this.getMenus()));
    }

    @Override
    protected void tabComplete(CommandSender sender, String[] args, List<String> options) {
        if (args.length == 2) {
            options.addAll(this.getMenus());
        }
    }
}

