/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandPermission
extends SubCommand {
    public SubCommandPermission(UltraCosmetics ultraCosmetics) {
        super("permission", "Unlocks or locks a cosmetic for you or another user", "<add|remove> <category|*> <cosmetic|*> [player]", ultraCosmetics);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        Player target;
        boolean unlock;
        if (args.length < 4) {
            this.badUsage(sender);
            return;
        }
        if (args[1].equalsIgnoreCase("add")) {
            unlock = true;
        } else {
            if (!args[1].equalsIgnoreCase("remove")) {
                this.error(sender, "Must provide 'add' or 'remove' for first arg");
                return;
            }
            if (!this.ultraCosmetics.getPermissionManager().isUnsetSupported()) {
                this.error(sender, String.valueOf(ChatColor.RED) + "Removing cosmetic permissions through UC is only supported when UC is storing unlocked cosmetics.");
                this.error(sender, String.valueOf(ChatColor.RED) + "Please use your permission plugin commands to remove cosmetic permissions instead.");
                return;
            }
            unlock = false;
        }
        if (args.length == 4) {
            if (!(sender instanceof Player)) {
                this.error(sender, "A target player is required.");
                return;
            }
            target = (Player)sender;
        } else {
            target = Bukkit.getPlayer((String)args[4]);
            if (target == null) {
                this.error(sender, "Invalid player: " + args[4]);
                return;
            }
        }
        HashSet cosmetics = new HashSet();
        if (args[2].equals("*")) {
            if (!args[3].equals("*")) {
                this.error(sender, "Cannot set specific cosmetic in wildcard category");
                return;
            }
            Category.forEachCosmetic(cosmetics::add);
        } else {
            Category cat = Category.fromString(args[2]);
            if (cat == null) {
                this.error(sender, "No such category: " + args[2]);
                return;
            }
            if (args[3].equals("*")) {
                cosmetics.addAll(cat.getValues());
            } else {
                CosmeticType<?> type = cat.valueOfType(args[3]);
                if (type == null) {
                    this.error(sender, "No such cosmetic: " + args[3]);
                    return;
                }
                cosmetics.add(type);
            }
        }
        if (unlock) {
            this.ultraCosmetics.getPermissionManager().setPermissions(target, cosmetics);
        } else {
            this.ultraCosmetics.getPermissionManager().unsetPermissions(target, cosmetics);
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Success!");
    }

    @Override
    protected void tabComplete(CommandSender sender, String[] args, List<String> options) {
        if (args.length == 2) {
            options.add("add");
            options.add("remove");
        } else if (args.length == 3) {
            this.addCategories(options);
            options.add("*");
        } else if (args.length == 4) {
            Category cat = Category.fromString(args[2]);
            if (cat == null || !cat.isEnabled()) {
                return;
            }
            for (CosmeticType<?> type : cat.getEnabled()) {
                options.add(type.getConfigName());
            }
            options.add("*");
        } else if (args.length == 5) {
            this.addPlayers(options);
        }
    }
}

