/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.treasurechests.TreasureLocation;
import be.isach.ultracosmetics.treasurechests.TreasureRandomizer;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.version.VersionManager;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandTreasure
extends SubCommand {
    public SubCommandTreasure(UltraCosmetics ultraCosmetics) {
        super("treasure", "Starts Treasure Chest.", "[player] [<x> <y> <z>] [world]", ultraCosmetics);
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        World world;
        int z;
        int y;
        int x;
        boolean structureEnabled;
        Player opener;
        if (args.length < 2 && !(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You must specify a player.");
            return;
        }
        if (args.length > 6) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Incorrect Usage! " + this.getUsage());
            return;
        }
        if (args.length == 1) {
            opener = (Player)sender;
        } else {
            opener = Bukkit.getPlayer((String)args[1]);
            if (opener == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Player " + args[1] + " not found!");
                return;
            }
        }
        UltraPlayer ultraPlayer = UltraCosmeticsData.get().getPlugin().getPlayerManager().getUltraPlayer(opener);
        if (ultraPlayer.getKeys() <= 0) {
            opener.closeInventory();
            this.ultraCosmetics.getMenus().openKeyPurchaseMenu(ultraPlayer);
            return;
        }
        boolean bl = structureEnabled = !SettingsManager.getConfig().getString("TreasureChests.Mode", "").equalsIgnoreCase("simple");
        if (args.length < 3) {
            if (!this.checkWorld(sender, opener.getWorld())) {
                return;
            }
            if (structureEnabled && this.ultraCosmetics.getTreasureChestManager().tryOpenChest(opener)) {
                return;
            }
            ultraPlayer.removeKey();
            TreasureRandomizer tr = new TreasureRandomizer(opener, opener.getLocation().subtract(1.0, 0.0, 1.0), true);
            for (int i = 0; i < SettingsManager.getConfig().getInt("TreasureChests.Count", 4); ++i) {
                tr.giveRandomThing(null, false);
            }
            return;
        }
        if (!structureEnabled) {
            MessageManager.send(sender, "Structure-Chests-Disabled", new TagResolver.Single[0]);
            return;
        }
        try {
            x = Integer.parseInt(args[2]);
            y = Integer.parseInt(args[3]);
            z = Integer.parseInt(args[4]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED.toString() + String.valueOf(ChatColor.BOLD) + "Invalid coordinates!");
            return;
        }
        if (args.length > 5) {
            world = Bukkit.getWorld((String)args[5]);
            if (world == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "World " + args[5] + " doesn't exist!");
                return;
            }
        } else {
            world = opener.getWorld();
        }
        if (y >= VersionManager.getWorldMaxHeight(world) || y <= VersionManager.getWorldMinHeight(world)) {
            MessageManager.send(sender, "Chest-Location.Invalid", new TagResolver.Single[0]);
            return;
        }
        Location location = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        Block block = location.getBlock();
        if (!this.isAir(block)) {
            MessageManager.send(sender, "Chest-Location.In-Ground", new TagResolver.Single[0]);
            for (int i = y; i < VersionManager.getWorldMaxHeight(world); ++i) {
                if (!this.isAir(block.getWorld().getBlockAt(x, i, z))) continue;
                this.suggest(x, i, z, sender);
                break;
            }
            return;
        }
        if (this.isAir(block.getRelative(BlockFace.DOWN))) {
            MessageManager.send(sender, "Chest-Location.In-Air", new TagResolver.Single[0]);
            for (int i = y; i > VersionManager.getWorldMinHeight(world); --i) {
                if (this.isAir(block.getWorld().getBlockAt(x, i, z))) continue;
                this.suggest(x, i + 1, z, sender);
                break;
            }
            return;
        }
        this.ultraCosmetics.getTreasureChestManager().tryOpenChest(opener, TreasureLocation.fromLocation(location));
    }

    private boolean checkWorld(CommandSender sender, World world) {
        if (SettingsManager.isAllowedWorld(world)) {
            return true;
        }
        MessageManager.send(sender, "World-Disabled", new TagResolver.Single[0]);
        return false;
    }

    private void suggest(int x, int y, int z, CommandSender sender) {
        MessageManager.send(sender, "Chest-Location.Suggestion", Placeholder.unparsed("location", x + "," + y + "," + z));
    }

    private boolean isAir(Block block) {
        return BlockUtils.isAir(block.getType());
    }

    @Override
    protected void tabComplete(CommandSender sender, String[] args, List<String> options) {
        if (args.length == 2) {
            this.addPlayers(options);
        } else if (args.length == 6) {
            for (World world : Bukkit.getWorlds()) {
                options.add(world.getName());
            }
        }
    }
}

