/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import com.cryptomorin.xseries.XMaterial;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class ArmorCosmetic<T extends CosmeticType<?>>
extends Cosmetic<T> {
    protected final Map<Attribute, Double> attributes = this.getAttributes();
    protected ItemStack itemStack;

    public ArmorCosmetic(UltraPlayer owner, T type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void clear() {
        super.clear();
        this.setArmorItem(null);
    }

    @Override
    protected boolean tryEquip() {
        return this.trySetSlot();
    }

    protected boolean trySetSlot() {
        this.getOwner().removeCosmetic(Category.suitsFromSlot(this.getArmorSlot()));
        if (this.getArmorSlot() == ArmorSlot.HELMET) {
            this.getOwner().removeCosmetic(Category.HATS);
            this.getOwner().removeCosmetic(Category.EMOTES);
        }
        if (this.getArmorItem() != null && this.getArmorItem().getType() != Material.AIR) {
            this.getOwner().sendMessage(MessageManager.getMessage(this.getOccupiedSlotKey(), new TagResolver.Single[0]));
            return false;
        }
        if (this.itemStack != null) {
            this.writeAttributes(this.itemStack);
            ItemFactory.applyCosmeticMarker(this.itemStack);
            this.setArmorItem(this.itemStack);
        }
        return true;
    }

    protected void writeAttributes(ItemStack stack) {
        if (this.attributes.isEmpty()) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta.hasAttributeModifiers()) {
            meta.removeAttributeModifier(this.getArmorSlot().toBukkit());
        }
        int count = 0;
        for (Map.Entry<Attribute, Double> entry : this.attributes.entrySet()) {
            AttributeModifier mod = ItemFactory.createAttributeModifier("custom_mod_" + count++, entry.getValue(), AttributeModifier.Operation.ADD_NUMBER, this.getArmorSlot().toBukkit());
            meta.addAttributeModifier(entry.getKey(), mod);
        }
        stack.setItemMeta(meta);
    }

    private Map<Attribute, Double> getAttributes() {
        HashMap<Attribute, Double> attrs = new HashMap<Attribute, Double>();
        this.loadAttributes(attrs, SettingsManager.getConfig().getConfigurationSection("Attribute-Bonus." + this.getCategory().toString()));
        this.loadAttributes(attrs, SettingsManager.getConfig().getConfigurationSection(this.getOptionPath("Attribute-Bonus")));
        return attrs;
    }

    private void loadAttributes(Map<Attribute, Double> attrs, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            try {
                attrs.put(Attribute.valueOf((String)key), section.getDouble(key));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    protected ItemStack getArmorItem() {
        switch (this.getArmorSlot()) {
            case BOOTS: {
                return this.getPlayer().getInventory().getBoots();
            }
            case LEGGINGS: {
                return this.getPlayer().getInventory().getLeggings();
            }
            case CHESTPLATE: {
                return this.getPlayer().getInventory().getChestplate();
            }
            case HELMET: {
                return this.getPlayer().getInventory().getHelmet();
            }
        }
        return null;
    }

    protected void setArmorItem(ItemStack item) {
        switch (this.getArmorSlot()) {
            case BOOTS: {
                this.getPlayer().getInventory().setBoots(item);
                break;
            }
            case LEGGINGS: {
                this.getPlayer().getInventory().setLeggings(item);
                break;
            }
            case CHESTPLATE: {
                this.getPlayer().getInventory().setChestplate(item);
                break;
            }
            case HELMET: {
                this.getPlayer().getInventory().setHelmet(item);
            }
        }
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        this.handleClick(event);
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        if (event.getPlayer() == this.getPlayer() && this.isItemThis(event.getItemDrop().getItemStack())) {
            event.getItemDrop().remove();
            this.handleDrop();
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getPlayer() != this.getPlayer() || !event.hasItem()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Material itemType = event.getItem().getType();
        if (itemType.name().endsWith("_" + String.valueOf((Object)this.getArmorSlot())) || itemType == XMaterial.ELYTRA.get() && this.getArmorSlot() == ArmorSlot.CHESTPLATE) {
            event.setUseItemInHand(Event.Result.DENY);
        }
        if (this.isItemThis(event.getItem())) {
            event.setUseItemInHand(Event.Result.DENY);
            this.clear();
        }
    }

    private void handleDrop() {
        if (SettingsManager.getConfig().getBoolean("Remove-Gadget-With-Drop")) {
            this.clear();
        }
    }

    private void handleClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack current = event.getCurrentItem();
        if (player == this.getPlayer() && (this.isItemThis(current) || this.isItemThis(event.getCursor()))) {
            event.setCancelled(true);
            if (event.getAction().name().contains("DROP")) {
                this.handleDrop();
            }
            if (player.getGameMode() == GameMode.CREATIVE) {
                player.closeInventory();
            }
        }
    }

    protected boolean isItemThis(ItemStack is) {
        return is != null && is.hasItemMeta() && is.getItemMeta().hasDisplayName() && is.getItemMeta().getDisplayName().equals(this.itemStack.getItemMeta().getDisplayName());
    }

    protected abstract ArmorSlot getArmorSlot();

    protected String getOccupiedSlotKey() {
        return "Must-Remove." + this.getCategory().getConfigPath();
    }
}

