/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.player.UltraPlayer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;

public interface PlayerAffectingCosmetic {
    default public boolean canAffect(Entity entity, Player owner) {
        if (!this.isAffectingPlayersEnabled()) {
            return false;
        }
        if (entity.hasMetadata("NPC") || entity.hasMetadata("Pet") || entity.hasMetadata("Mount")) {
            return false;
        }
        if (entity instanceof Player) {
            Player target = (Player)entity;
            if (Bukkit.getPlayer((UUID)target.getUniqueId()) == null) {
                return false;
            }
            if (PlayerAffectingCosmetic.isHidden(target, owner)) {
                return false;
            }
            UltraPlayer ultraPlayer = this.getSelf().getUltraCosmetics().getPlayerManager().getUltraPlayer(target);
            if (!ultraPlayer.canBeHitByOtherGadgets() || !ultraPlayer.hasGadgetsEnabled() || ultraPlayer.getCurrentTreasureChest() != null) {
                return false;
            }
            if (!this.getSelf().getUltraCosmetics().getWorldGuardManager().canAffectPlayersHere(target)) {
                return false;
            }
        } else {
            if (entity instanceof Creature && !UltraCosmeticsData.get().isCosmeticsAffectEntities()) {
                return false;
            }
            if (!(entity instanceof Creature)) {
                return false;
            }
        }
        return true;
    }

    default public boolean isAffectingPlayersEnabled() {
        Object type = this.getSelf().getType();
        return SettingsManager.getConfig().getBoolean(((CosmeticType)type).getCategory().getConfigPath() + "." + ((CosmeticType)type).getConfigName() + ".Affect-Players");
    }

    public static boolean isHidden(Player target, Player from) {
        if (!target.canSee(from) || !from.canSee(target)) {
            return true;
        }
        return PlayerAffectingCosmetic.isVanished(target);
    }

    public static boolean isVanished(Player target) {
        for (MetadataValue meta : target.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    default public Cosmetic<?> getSelf() {
        return (Cosmetic)((Object)this);
    }
}

