/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.EntitySpawner;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;

public class GadgetEtherealPearl
extends Gadget
implements Updatable {
    private static final Color PRIMARY_EFFECT = Color.fromRGB((int)100, (int)0, (int)100);
    private static final Color SECONDARY_EFFECT = Color.fromRGB((int)30, (int)0, (int)30);
    private EnderPearl pearl;
    private boolean running = false;
    private Location lastLoc = null;

    public GadgetEtherealPearl(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onEquip() {
        super.onEquip();
        this.getUltraCosmetics().getEntityDismountListener().addHandler(this, this::onEntityDismount);
    }

    @Override
    public void onClear() {
        if (this.pearl != null) {
            this.pearl.remove();
        }
        this.getUltraCosmetics().getEntityDismountListener().removeHandler(this);
    }

    @Override
    protected void onRightClick() {
        this.getOwner().removeCosmetic(Category.MOUNTS);
        Entity vehicle = this.getPlayer().getVehicle();
        if (vehicle instanceof EnderPearl) {
            this.pearl = null;
            this.getPlayer().eject();
            vehicle.remove();
        }
        this.pearl = (EnderPearl)this.getPlayer().launchProjectile(EnderPearl.class);
        this.pearl.setVelocity(this.getPlayer().getEyeLocation().getDirection().multiply(1.53));
        if (this.pearl == null) {
            return;
        }
        if (!this.pearl.addPassenger((Entity)this.getPlayer())) {
            this.pearl.remove();
            return;
        }
        if (!this.getPlayer().getAllowFlight()) {
            this.getPlayer().setAllowFlight(true);
        }
        this.running = true;
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (this.running && event.getCause() == EntityDamageEvent.DamageCause.FALL && event.getEntity() == this.getPlayer()) {
            event.setCancelled(true);
        }
    }

    public boolean onEntityDismount(Entity who, Entity dismounted) {
        if (this.pearl != null && who == this.getPlayer()) {
            this.endRide();
        }
        return false;
    }

    @EventHandler
    public void onItemFrameBreak(HangingBreakByEntityEvent event) {
        if (event.getRemover() == this.pearl) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (event.getEntity() == this.pearl || event.getEntity() == this.getPlayer()) {
            event.getEntity().remove();
            this.pearl = null;
        }
    }

    private void endRide() {
        Location target;
        if (this.getPlayer().getGameMode() != GameMode.CREATIVE) {
            this.getPlayer().setAllowFlight(false);
        }
        if (this.pearl != null) {
            this.pearl.remove();
            this.pearl = null;
        }
        if (this.lastLoc != null && BlockUtils.isAir((target = this.lastLoc.clone().add(0.0, 1.0, 0.0)).getBlock().getType())) {
            this.getUltraCosmetics().getScheduler().teleportAsync((Entity)this.getPlayer(), target);
        }
        EntitySpawner.spawnFireworks(this.getPlayer().getLocation(), PRIMARY_EFFECT, SECONDARY_EFFECT);
        this.running = false;
    }

    @Override
    public void onUpdate() {
        if (this.running && (this.pearl == null || !this.pearl.isValid())) {
            this.endRide();
        } else {
            this.lastLoc = this.getPlayer().getLocation();
        }
    }

    @EventHandler
    public void onPortal(EntityPortalEvent event) {
        if (event.getEntity() == this.pearl) {
            event.setCancelled(true);
            this.pearl.remove();
            this.pearl = null;
        }
    }
}

