/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XEntityType;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetQuakeGun
extends Gadget
implements PlayerAffectingCosmetic {
    private static final FireworkEffect FIREWORK_EFFECT = FireworkEffect.builder().flicker(false).trail(false).with(FireworkEffect.Type.BALL_LARGE).withColor(Color.RED).withFade(Color.ORANGE).build();
    private static final EntityType FIREWORK_ENTITY = XEntityType.FIREWORK_ROCKET.get();
    private static final ParticleDisplay FLAME = ParticleDisplay.of((XParticle)XParticle.FLAME).withCount(60).withExtra((double)0.4f);
    private final List<Firework> fireworkList = new ArrayList<Firework>();
    private final XSound.SoundPlayer sound = XSound.ENTITY_BLAZE_DEATH.record().withVolume(1.4f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});

    public GadgetQuakeGun(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.sound.play();
        Location location = this.getPlayer().getEyeLocation().subtract(0.0, 0.4, 0.0);
        Vector vector = location.getDirection();
        for (int i = 0; i < 20; ++i) {
            Firework firework = (Firework)location.getWorld().spawnEntity(location, FIREWORK_ENTITY);
            firework.setMetadata("uc_firework", (MetadataValue)new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)true));
            location.add(vector);
            this.fireworkList.add(firework);
            List nearbyEntities = firework.getNearbyEntities(0.5, 0.5, 0.5);
            Player player = this.getPlayer();
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof Player) && !(entity instanceof Creature) || entity == player || !this.canAffect(entity, player)) continue;
                MathUtils.applyVelocity(entity, new Vector(0, 1, 0));
                FLAME.spawn(entity.getLocation());
                UltraCosmeticsData.get().getVersionManager().getModule().spawnFirework(location, FIREWORK_EFFECT, new Player[0]);
            }
        }
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
            for (Firework firework : this.fireworkList) {
                firework.remove();
            }
            this.fireworkList.clear();
        }, 6L);
    }
}

