/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.run.FallDamageManager;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.shaded.tcoded.folialib.wrapper.task.WrappedTask;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.StructureRollback;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class GadgetRocket
extends Gadget
implements Updatable {
    private static final BlockFace[] CARDINAL = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    private static final Material FENCE = XMaterial.OAK_FENCE.get();
    private static final Material QUARTZ_BLOCK = XMaterial.QUARTZ_BLOCK.get();
    private static final ParticleDisplay EMITTER = ParticleDisplay.of((XParticle)XParticle.EXPLOSION_EMITTER);
    private final ParticleDisplay flame = ParticleDisplay.of((XParticle)XParticle.FLAME).withCount(10).offset(0.3, 0.2, 0.3).withLocationCaller(() -> this.getPlayer().getLocation().subtract(0.0, 3.0, 0.0));
    private final ParticleDisplay lava = this.flame.copy().withParticle(XParticle.LAVA);
    private final StructureRollback rollback = new StructureRollback();
    private boolean stillEquipped = true;
    private boolean launching;
    private ArmorStand armorStand;
    private final List<FallingBlock> fallingBlocks = new ArrayList<FallingBlock>();
    private Entity playerVehicle = null;
    private int height;
    private RocketTask activeTask = null;
    private final XSound.SoundPlayer countdownSound = XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    private final XSound.SoundPlayer liftoffSound = XSound.ENTITY_GENERIC_EXPLODE.record().publicSound(true).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    private final XSound.SoundPlayer flightSound1 = XSound.ENTITY_BAT_LOOP.record().withVolume(1.5f).soundPlayer();
    private final XSound.SoundPlayer flightSound2 = XSound.BLOCK_FIRE_EXTINGUISH.record().withVolume(0.025f).soundPlayer();

    public GadgetRocket(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.getPlayer().setVelocity(new Vector(0, 1, 0));
        Location loc = this.getPlayer().getLocation();
        loc.setX((double)loc.getBlockX() + 0.5);
        loc.setY((double)loc.getBlockY());
        loc.setZ((double)loc.getBlockZ() + 0.5);
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
            if (this.getOwner() == null || this.getOwner().getCurrentGadget() != this) {
                return;
            }
            for (int i = 0; i < 2; ++i) {
                Block center = loc.clone().add(0.0, (double)i, 0.0).getBlock();
                for (BlockFace face : CARDINAL) {
                    this.rollback.setToRestore(center.getRelative(face), FENCE);
                }
                this.rollback.setToRestore(center.getRelative(BlockFace.UP), QUARTZ_BLOCK);
            }
            this.armorStand = (ArmorStand)loc.getWorld().spawn(loc.add(0.0, 1.5, 0.0), ArmorStand.class);
            this.armorStand.setVisible(false);
            this.armorStand.setGravity(false);
        }, 10L);
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
            if (this.getOwner() == null || this.getOwner().getCurrentGadget() != this) {
                return;
            }
            this.enableFlight();
            this.playerVehicle = null;
            this.armorStand.addPassenger((Entity)this.getPlayer());
            this.playerVehicle = this.armorStand;
            this.activeTask = new RocketTask(){
                private int countdown = 3;

                @Override
                public void run() {
                    if (GadgetRocket.this.getOwner() == null || GadgetRocket.this.getPlayer() == null || !GadgetRocket.this.getPlayer().isOnline()) {
                        this.task.cancel();
                        return;
                    }
                    if (!GadgetRocket.this.isStillCurrentGadget()) {
                        this.task.cancel();
                        return;
                    }
                    if (this.countdown > 0) {
                        GadgetRocket.this.sendTitle(ChatColor.RED.toString() + String.valueOf(ChatColor.BOLD) + this.countdown);
                        GadgetRocket.this.countdownSound.play();
                        --this.countdown;
                        return;
                    }
                    this.stop();
                    GadgetRocket.this.sendTitle(MessageManager.getLegacyMessage("Gadgets.Rocket.Takeoff", new TagResolver.Single[0]));
                    GadgetRocket.this.liftoffSound.play();
                    FallingBlock top = BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, 3.0, 0.0), QUARTZ_BLOCK);
                    FallingBlock base = BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, 2.0, 0.0), QUARTZ_BLOCK);
                    for (int i = 0; i < 2; ++i) {
                        GadgetRocket.this.fallingBlocks.add(BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, (double)(1 + i), 1.0), FENCE));
                        GadgetRocket.this.fallingBlocks.add(BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, (double)(1 + i), -1.0), FENCE));
                        GadgetRocket.this.fallingBlocks.add(BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(1.0, (double)(1 + i), 0.0), FENCE));
                        GadgetRocket.this.fallingBlocks.add(BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(-1.0, (double)(1 + i), 0.0), FENCE));
                    }
                    GadgetRocket.this.fallingBlocks.add(top);
                    GadgetRocket.this.fallingBlocks.add(base);
                    if (GadgetRocket.this.fallingBlocks.get(8).getPassengers().isEmpty()) {
                        GadgetRocket.this.fallingBlocks.get(8).addPassenger((Entity)GadgetRocket.this.getPlayer());
                    }
                    top.addPassenger((Entity)GadgetRocket.this.getPlayer());
                    GadgetRocket.this.playerVehicle = top;
                    GadgetRocket.this.launching = true;
                    GadgetRocket.this.activeTask = new RocketTask(){

                        @Override
                        public void run() {
                            if (GadgetRocket.this.getPlayer().getLocation().getBlockY() < GadgetRocket.this.height - 10) {
                                return;
                            }
                            GadgetRocket.this.playerVehicle = null;
                            if (!GadgetRocket.this.isStillCurrentGadget()) {
                                this.task.cancel();
                                GadgetRocket.this.activeTask = null;
                                return;
                            }
                            this.stop();
                            GadgetRocket.this.activeTask = null;
                        }

                        @Override
                        public void stop() {
                            GadgetRocket.this.fallingBlocks.forEach(Entity::remove);
                            GadgetRocket.this.fallingBlocks.clear();
                            FallDamageManager.addNoFall((Entity)GadgetRocket.this.getPlayer());
                            GadgetRocket.this.liftoffSound.play();
                            EMITTER.spawn(GadgetRocket.this.getPlayer().getLocation());
                            GadgetRocket.this.disableFlight();
                            GadgetRocket.this.launching = false;
                            this.task.cancel();
                        }
                    }.schedule(GadgetRocket.this.getUltraCosmetics(), GadgetRocket.this.getPlayer(), 5L, 5L);
                }

                @Override
                public void stop() {
                    GadgetRocket.this.playerVehicle = null;
                    GadgetRocket.this.armorStand.remove();
                    GadgetRocket.this.armorStand = null;
                    GadgetRocket.this.rollback.rollback();
                    GadgetRocket.this.sendTitle(" ");
                    this.task.cancel();
                }
            }.schedule(this.getUltraCosmetics(), this.getPlayer(), 0L, 20L);
        }, 12L);
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        if (this.activeTask != null) {
            return false;
        }
        this.height = Area.findMaxY(this.getPlayer().getLocation(), 1);
        if (this.height < 25) {
            MessageManager.send((CommandSender)this.getPlayer(), "Gadgets.Rocket.Not-Enough-Space", new TagResolver.Single[0]);
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            MessageManager.send((CommandSender)this.getPlayer(), "Gadgets.Rocket.Not-On-Ground", new TagResolver.Single[0]);
            return false;
        }
        return true;
    }

    private boolean isStillCurrentGadget() {
        return this.stillEquipped;
    }

    @Override
    public void onUpdate() {
        for (FallingBlock fallingBlock : this.fallingBlocks) {
            fallingBlock.setVelocity(new Vector(0.0, 0.9, 0.0));
        }
        if (this.launching && !this.fallingBlocks.isEmpty()) {
            this.flame.spawn();
            this.lava.spawn();
            Location soundLoc = this.fallingBlocks.get(9).getLocation().clone().add(0.0, -1.0, 0.0);
            this.flightSound1.atLocation(soundLoc).play();
            this.flightSound2.atLocation(soundLoc).play();
        }
    }

    protected void cleanup() {
        this.rollback.rollback();
        for (FallingBlock fallingBlock : this.fallingBlocks) {
            fallingBlock.remove();
        }
        this.playerVehicle = null;
        this.fallingBlocks.clear();
        if (this.armorStand != null) {
            this.armorStand.remove();
        }
        this.disableFlight();
        this.launching = false;
        if (this.getPlayer() != null) {
            this.sendTitle(" ");
        }
        if (this.activeTask != null) {
            this.activeTask.cancel();
        }
    }

    @Override
    public void onEquip() {
        super.onEquip();
        this.getUltraCosmetics().getEntityDismountListener().addHandler(this, this::onDismount);
    }

    @Override
    public void onClear() {
        this.stillEquipped = false;
        this.cleanup();
        this.rollback.cleanup();
        this.getUltraCosmetics().getEntityDismountListener().removeHandler(this);
    }

    public boolean onDismount(Entity who, Entity dismounted) {
        if (who != this.getPlayer() || dismounted != this.playerVehicle) {
            return false;
        }
        this.disableFlight();
        this.activeTask.cancel();
        if (this.activeTask != null) {
            this.activeTask.stop();
            this.activeTask = null;
        }
        return false;
    }

    private void enableFlight() {
        this.getPlayer().setAllowFlight(true);
    }

    private void disableFlight() {
        if (this.getPlayer().getGameMode() != GameMode.CREATIVE) {
            this.getPlayer().setAllowFlight(false);
        }
    }

    private void sendTitle(String title) {
        this.getPlayer().sendTitle(title, "");
    }

    private static abstract class RocketTask {
        protected WrappedTask task;

        private RocketTask() {
        }

        public abstract void stop();

        public abstract void run();

        public void cancel() {
            if (this.task != null) {
                this.task.cancel();
            }
        }

        public RocketTask schedule(UltraCosmetics ultraCosmetics, Player player, long delay, long period) {
            this.task = ultraCosmetics.getScheduler().runAtEntityTimer((Entity)player, this::run, delay, period);
            return this;
        }
    }
}

