/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.tcoded.folialib.wrapper.task.WrappedTask;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.StructureRollback;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public class GadgetSmashDown
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private static final Particle BLOCK_PARTICLE = XParticle.BLOCK.get();
    private final XSound.SoundPlayer useSound;
    private final XSound.SoundPlayer smashSound;
    private final XSound.SoundPlayer landSound;
    private final ParticleDisplay cloud = ParticleDisplay.of((XParticle)XParticle.CLOUD).withLocationCaller(() -> this.getPlayer().getLocation());
    private final List<FallingBlock> fallingBlocks = new ArrayList<FallingBlock>();
    private boolean active = false;
    private int i = 1;
    private boolean playEffect;
    private WrappedTask gadgetTask;

    public GadgetSmashDown(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.useSound = XSound.ENTITY_FIREWORK_ROCKET_LAUNCH.record().withVolume(2.0f).publicSound(true).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
        this.smashSound = XSound.ENTITY_GENERIC_EXPLODE.record().withVolume(2.0f).publicSound(true).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
        this.landSound = XSound.BLOCK_ANVIL_BREAK.record().withVolume(0.05f).publicSound(true).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    }

    @Override
    protected void onRightClick() {
        this.useSound.play();
        this.getPlayer().setVelocity(new Vector(0, 3, 0));
        this.gadgetTask = this.getUltraCosmetics().getScheduler().runAtEntityTimer((Entity)this.getPlayer(), () -> {
            if (this.getOwner() != null && this.getPlayer() != null && this.isEquipped()) {
                this.cloud.spawn();
            } else {
                this.gadgetTask.cancel();
            }
        }, 0L, 1L);
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
            if (this.getOwner() != null && this.getPlayer() != null && this.isEquipped()) {
                this.gadgetTask.cancel();
                this.getOwner().applyVelocity(new Vector(0, -3, 0));
                this.active = true;
            }
        }, 25L);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (this.active && event.getEntity() == this.getPlayer()) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onUpdate() {
        if (this.active && this.getPlayer().isOnGround()) {
            this.playEffect = true;
            this.getUltraCosmetics().getScheduler().runLaterAsync(() -> {
                this.active = false;
            }, 5L);
            return;
        }
        if (!this.playEffect) {
            return;
        }
        Location loc = this.getPlayer().getLocation();
        this.smashSound.play();
        if (this.i == 5) {
            this.playEffect = false;
            this.active = false;
            this.i = 1;
            return;
        }
        if (this.getOwner().getCurrentGadget() != this) {
            this.playEffect = false;
            this.active = false;
            return;
        }
        for (Block b : BlockUtils.getBlocksInRadius(loc.clone().add(0.0, -1.0, 0.0), this.i, true)) {
            if (b.getLocation().getBlockY() != loc.getBlockY() - 1 || BlockUtils.isBadMaterial(b.getType()) || StructureRollback.isBlockRollingBack(b) || !b.getType().isSolid() || !BlockUtils.isAir(b.getRelative(BlockFace.UP).getType())) continue;
            this.getUltraCosmetics().getScheduler().runAtEntity((Entity)this.getPlayer(), task -> {
                FallingBlock fb = BlockUtils.spawnFallingBlock(b.getLocation().clone().add(0.0, (double)1.1f, 0.0), b);
                fb.setVelocity(new Vector(0.0f, 0.3f, 0.0f));
                fb.setDropItem(false);
                this.fallingBlocks.add(fb);
                Player player = this.getPlayer();
                fb.getNearbyEntities(1.0, 1.0, 1.0).stream().filter(ent -> ent != player && !(ent instanceof FallingBlock) && this.canAffect((Entity)ent, player)).forEach(ent -> MathUtils.applyVelocity(ent, new Vector(0.0, 0.5, 0.0)));
            });
        }
        ++this.i;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockChangeState(EntityChangeBlockEvent event) {
        if (!this.fallingBlocks.remove(event.getEntity())) {
            return;
        }
        event.setCancelled(true);
        FallingBlock fb = (FallingBlock)event.getEntity();
        BlockData data = fb.getBlockData();
        fb.getWorld().spawnParticle(BLOCK_PARTICLE, fb.getLocation(), 50, 0.0, 0.0, 0.0, 0.4, (Object)data);
        this.landSound.play();
        event.getEntity().remove();
    }

    @Override
    public void onClear() {
        for (FallingBlock block : this.fallingBlocks) {
            block.remove();
        }
    }
}

