/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class GadgetTNT
extends Gadget
implements PlayerAffectingCosmetic {
    private static final ParticleDisplay EMITTER = ParticleDisplay.of((XParticle)XParticle.EXPLOSION_EMITTER);
    private final Set<Entity> entities = new HashSet<Entity>();
    private final XSound.SoundPlayer sound = XSound.ENTITY_GENERIC_EXPLODE.record().withVolume(1.4f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});

    public GadgetTNT(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        TNTPrimed tnt = (TNTPrimed)this.getPlayer().getWorld().spawn(this.getPlayer().getLocation().add(0.0, 2.0, 0.0), TNTPrimed.class);
        tnt.setFuseTicks(20);
        tnt.setVelocity(this.getPlayer().getLocation().getDirection().multiply(0.854321));
        this.entities.add((Entity)tnt);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (this.entities.contains(event.getDamager())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemFrameBreak(HangingBreakEvent event) {
        for (Entity ent : this.entities) {
            if (ent.getWorld() != event.getEntity().getWorld() || !(ent.getLocation().distanceSquared(event.getEntity().getLocation()) < 225.0)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        for (Entity tnt : this.entities) {
            if (tnt.getWorld() != event.getVehicle().getWorld() || !(tnt.getLocation().distanceSquared(event.getVehicle().getLocation()) < 100.0)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!this.entities.remove(event.getEntity())) {
            return;
        }
        event.setCancelled(true);
        EMITTER.spawn(event.getEntity().getLocation());
        this.sound.play();
        Player player = this.getPlayer();
        for (Entity ent : event.getEntity().getNearbyEntities(3.0, 3.0, 3.0)) {
            if (!this.canAffect(ent, player)) continue;
            Vector vector = GadgetTNT.getVector(event, ent);
            MathUtils.applyVelocity(ent, vector.multiply(1.3).add(new Vector(0.0, 1.4, 0.0)));
        }
    }

    @NotNull
    private static Vector getVector(EntityExplodeEvent event, Entity ent) {
        double dX = event.getEntity().getLocation().getX() - ent.getLocation().getX();
        double dY = event.getEntity().getLocation().getY() - ent.getLocation().getY();
        double dZ = event.getEntity().getLocation().getZ() - ent.getLocation().getZ();
        double yaw = Math.atan2(dZ, dX);
        double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
        double X = Math.sin(pitch) * Math.cos(yaw);
        double Y = Math.sin(pitch) * Math.sin(yaw);
        double Z = Math.cos(pitch);
        return new Vector(X, Z, Y);
    }

    @Override
    public void onClear() {
        for (Entity ent : this.entities) {
            ent.remove();
        }
        this.entities.clear();
    }
}

