/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.StructureRollback;
import com.cryptomorin.xseries.XBlock;
import com.cryptomorin.xseries.XMaterial;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class GadgetTrampoline
extends Gadget
implements Updatable {
    private final StructureRollback rollback = new StructureRollback();
    private Area cuboid;
    private Location center;
    private boolean running;

    public GadgetTrampoline(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.clearBlocks();
        this.center = this.getPlayer().getLocation();
        this.cuboid = new Area(this.center, 2, 15);
        this.generateStructure();
        this.getUltraCosmetics().getScheduler().teleportAsync((Entity)this.getPlayer(), this.getPlayer().getLocation().add(0.0, 4.0, 0.0));
        this.running = true;
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        Location loc1 = event.getPlayer().getLocation().add(2.0, 15.0, 2.0);
        Location loc2 = event.getPlayer().getLocation().add(-3.0, 0.0, -2.0);
        Block ladder1 = loc1.getBlock().getRelative(3, 0, 0);
        Block ladder2 = loc1.getBlock().getRelative(3, 1, 0);
        Area checkArea = new Area(loc1, loc2);
        if (!(checkArea.isEmpty() && BlockUtils.isAir(ladder1.getType()) && BlockUtils.isAir(ladder2.getType()))) {
            MessageManager.send((CommandSender)this.getPlayer(), "Gadgets.Rocket.Not-Enough-Space", new TagResolver.Single[0]);
            return false;
        }
        return true;
    }

    @Override
    public void onUpdate() {
        if (this.running && this.cuboid != null) {
            for (Entity entity : this.center.getWorld().getNearbyEntities(this.center, 4.0, 4.0, 4.0)) {
                Block b = entity.getLocation().getBlock().getRelative(BlockFace.DOWN);
                if (!b.getType().toString().contains("WOOL") || !this.cuboid.contains(b)) continue;
                MathUtils.applyVelocity(entity, new Vector(0, 3, 0));
            }
        }
    }

    @Override
    public void onClear() {
        this.clearBlocks();
        this.rollback.cleanup();
    }

    private void generateStructure() {
        this.genBarr(this.get(2, 0, 2));
        this.genBarr(this.get(-2, 0, 2));
        this.genBarr(this.get(2, 0, -2));
        this.genBarr(this.get(-2, 0, -2));
        this.genBlue(this.get(2, 1, 2));
        this.genBlue(this.get(2, 1, 1));
        this.genBlue(this.get(2, 1, 0));
        this.genBlue(this.get(2, 1, -1));
        this.genBlue(this.get(2, 1, -2));
        this.genBlue(this.get(-2, 1, 2));
        this.genBlue(this.get(-2, 1, 1));
        this.genBlue(this.get(-2, 1, 0));
        this.genBlue(this.get(-2, 1, -1));
        this.genBlue(this.get(-2, 1, -2));
        this.genBlue(this.get(1, 1, 2));
        this.genBlue(this.get(0, 1, 2));
        this.genBlue(this.get(-1, 1, 2));
        this.genBlue(this.get(1, 1, -2));
        this.genBlue(this.get(0, 1, -2));
        this.genBlue(this.get(-1, 1, -2));
        this.genBlack(this.get(0, 1, 0));
        this.genBlack(this.get(0, 1, 1));
        this.genBlack(this.get(1, 1, 0));
        this.genBlack(this.get(0, 1, -1));
        this.genBlack(this.get(-1, 1, 0));
        this.genBlack(this.get(1, 1, 1));
        this.genBlack(this.get(-1, 1, -1));
        this.genBlack(this.get(1, 1, -1));
        this.genBlack(this.get(-1, 1, 1));
        this.genLadder(this.get(-3, 1, 0));
        this.genLadder(this.get(-3, 0, 0));
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), this::clearBlocks, 240L);
    }

    private void genBarr(Block block) {
        this.setToRestore(block, XMaterial.OAK_FENCE);
    }

    private void genBlue(Block block) {
        this.setToRestore(block, XMaterial.BLUE_WOOL);
    }

    private void genBlack(Block block) {
        this.setToRestore(block, XMaterial.BLACK_WOOL);
    }

    private void genLadder(Block block) {
        this.setToRestore(block, XMaterial.LADDER);
        XBlock.setDirection((Block)block, (BlockFace)BlockFace.WEST);
    }

    private void setToRestore(Block block, XMaterial material) {
        this.rollback.setToRestore(block, material, material != XMaterial.LADDER);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.cuboid == null || !this.running) {
            return;
        }
        if (this.cuboid.contains(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    private void clearBlocks() {
        this.rollback.rollback();
        this.cuboid = null;
        this.running = false;
    }

    private Block get(int x, int y, int z) {
        return this.center.getBlock().getRelative(x, y, z);
    }
}

