/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class MorphMooshroom
extends Morph
implements PlayerAffectingCosmetic {
    private final XSound.Record sound = XSound.ENTITY_SHEEP_SHEAR.record().withVolume(0.4f);

    public MorphMooshroom(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSneak(PlayerToggleSneakEvent event) {
        Player player = this.getPlayer();
        if (!this.canUseSkill || event.getPlayer() != player || !this.getOwner().getAndSetCooldown(this.cosmeticType, 10.0, 3.0)) {
            return;
        }
        for (Entity ent : player.getNearbyEntities(3.0, 3.0, 3.0)) {
            if (!this.canAffect(ent, player)) continue;
            MathUtils.applyVelocity(ent, ent.getLocation().toVector().subtract(player.getLocation().toVector()).setY(1));
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 20; ++i) {
            Location itemLoc = player.getLocation().add(Math.random() * 5.0 - 2.5, Math.random() * 3.0, Math.random() * 5.0 - 2.5);
            items.add(ItemFactory.spawnUnpickableItem(XMaterial.MUSHROOM_STEW.parseItem(), itemLoc, MathUtils.getRandomVector()));
        }
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
            for (Entity soup : items) {
                soup.remove();
            }
            items.clear();
        }, 50L);
        this.sound.withPitch((float)Math.random() + 1.0f).soundPlayer().forPlayers(new Player[]{player}).play();
    }
}

