/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.EntityCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.run.MountRegionChecker;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.task.UltraTask;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.version.VersionManager;
import com.cryptomorin.xseries.XMaterial;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class Mount
extends EntityCosmetic<MountType, Entity>
implements Updatable {
    private UltraTask mountRegionTask = null;
    protected boolean beingRemoved = false;
    protected final boolean placesBlocks = ((MountType)this.getType()).doesPlaceBlocks();

    public Mount(UltraPlayer ultraPlayer, MountType type, UltraCosmetics ultraCosmetics) {
        super(ultraPlayer, type, ultraCosmetics);
    }

    @Override
    public void onEquip() {
        this.entity = this.spawnEntity();
        if (this.entity instanceof LivingEntity) {
            ((LivingEntity)this.entity).getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(((MountType)this.getType()).getMovementSpeed());
            if (this.entity instanceof Ageable) {
                ((Ageable)this.entity).setAdult();
            } else if (this.entity instanceof Slime) {
                ((Slime)this.entity).setSize(3);
            }
        }
        this.entity.setCustomNameVisible(true);
        this.entity.setCustomName(MessageManager.toLegacy(((MountType)this.getType()).getName(this.getPlayer())));
        this.entity.addPassenger((Entity)this.getPlayer());
        this.entity.setPersistent(false);
        this.entity.setMetadata("Mount", (MetadataValue)new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)"UltraCosmetics"));
        this.setupEntity();
        if (!this.getUltraCosmetics().getWorldGuardManager().isHooked()) {
            return;
        }
        if (this.isHorse(this.entity.getType())) {
            return;
        }
        this.mountRegionTask = new MountRegionChecker(this.getOwner(), this.getUltraCosmetics());
        this.mountRegionTask.schedule();
    }

    @Override
    protected void scheduleTask() {
        if (((MountType)this.getType()).getRepeatDelay() == 0) {
            return;
        }
        this.task = this.getUltraCosmetics().getScheduler().runAtEntityTimer((Entity)this.getPlayer(), this::run, 0L, (long)((MountType)this.getType()).getRepeatDelay());
    }

    @Override
    protected boolean tryEquip() {
        if (((MountType)this.getType()).isMonster() && this.getPlayer().getWorld().getDifficulty() == Difficulty.PEACEFUL) {
            this.getOwner().sendMessage(MessageManager.getMessage("Mounts.Cant-Spawn", new TagResolver.Single[0]));
            return false;
        }
        Location center = this.getPlayer().getLocation();
        center.setY(Math.ceil(center.getY()));
        Area area = new Area(center, 1, 1);
        if (!area.isTransparent()) {
            this.getOwner().sendMessage(MessageManager.getMessage("Mounts.Not-Enough-Room", new TagResolver.Single[0]));
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.entity.getPassengers().isEmpty() && this.entity.getTicksLived() > 10) {
            this.clear();
            return;
        }
        if (!this.entity.isValid()) {
            this.task.cancel();
            return;
        }
        if (this.entity.getLocation().getY() <= (double)(VersionManager.getWorldMinHeight(this.entity.getWorld()) - 15)) {
            this.clear();
            return;
        }
        if (this.getOwner() != null && Bukkit.getPlayer((UUID)this.getOwnerUniqueId()) != null && this.getOwner().getCurrentMount() != null && this.getOwner().getCurrentMount().getType() == this.getType()) {
            this.onUpdate();
        } else {
            this.task.cancel();
        }
    }

    @Override
    protected void onClear() {
        this.beingRemoved = true;
        this.removeEntity();
        if (this.mountRegionTask != null) {
            this.mountRegionTask.cancel();
        }
    }

    @EventHandler
    public void onPlayerToggleSneakEvent(VehicleExitEvent event) {
        if (event.getVehicle().getType() == EntityType.BOAT || event.getVehicle().getType() == EntityType.MINECART) {
            return;
        }
        if (event.getVehicle() == this.entity && !this.beingRemoved && event.getExited() == this.getPlayer()) {
            this.clear();
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() == this.getPlayer() && this.getOwner().getCurrentMount() == this && !this.getUltraCosmetics().getConfig().getBoolean("allow-damage-to-players-on-mounts")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getEntity() == this.getEntity() || event.getDamager() == this.getEntity()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMountPortal(EntityPortalEvent event) {
        if (event.getEntity() == this.getEntity()) {
            this.entity.remove();
            if (this.mountRegionTask != null) {
                this.mountRegionTask.cancel();
            }
            this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getEntity(), this::onEquip, 1L);
        }
    }

    @EventHandler
    public void openInv(InventoryOpenEvent event) {
        if (!this.isHorse(((MountType)this.getType()).getEntityType())) {
            return;
        }
        if (this.getOwner() != null && this.getPlayer() != null && event.getPlayer() == this.getPlayer() && event.getInventory().equals(((InventoryHolder)this.entity).getInventory())) {
            event.setCancelled(true);
        }
    }

    private boolean isHorse(EntityType type) {
        return AbstractHorse.class.isAssignableFrom(type.getEntityClass());
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.placesBlocks && event.getPlayer() == this.getPlayer() && this.getOwner().getCurrentMount() == this && SettingsManager.getConfig().getBoolean("Mounts-Block-Trails")) {
            List<XMaterial> mats = ItemFactory.getXMaterialListFromConfig("Mounts." + ((MountType)this.getType()).getConfigName() + ".Blocks-To-Place");
            if (mats.size() == 0) {
                return;
            }
            HashMap<Block, XMaterial> updates = new HashMap<Block, XMaterial>();
            for (Block b : BlockUtils.getBlocksInRadius(event.getPlayer().getLocation(), 3, false)) {
                if (b.getLocation().getBlockY() != event.getPlayer().getLocation().getBlockY() - 1) continue;
                XMaterial mat = mats.get(RANDOM.nextInt(mats.size()));
                updates.put(b, mat);
            }
            BlockUtils.setToRestore(updates, 20);
        }
    }
}

