/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.run.FallDamageManager;
import be.isach.ultracosmetics.shaded.mobchip.EntityBrain;
import be.isach.ultracosmetics.shaded.mobchip.ai.controller.NaturalMoveType;
import be.isach.ultracosmetics.shaded.mobchip.bukkit.BukkitBrain;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import org.bukkit.entity.EnderDragonPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MountDragon
extends Mount {
    private EntityBrain brain;
    private Mob boost = null;

    public MountDragon(UltraPlayer owner, MountType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void setupEntity() {
        if (this.getOwner().isGeyserClient()) {
            this.boost = EntitySpawningManager.withBypass(() -> (Mob)this.getPlayer().getWorld().spawnEntity(this.getPlayer().getLocation(), EntityType.GHAST));
            this.boost.setInvisible(true);
            this.boost.setAware(false);
            this.boost.setPersistent(false);
            this.entity.removePassenger((Entity)this.getPlayer());
            this.boost.addPassenger((Entity)this.getPlayer());
            this.entity.addPassenger((Entity)this.boost);
            this.entity.setMetadata("Mount", (MetadataValue)new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)"UltraCosmetics"));
        }
        this.brain = BukkitBrain.getBrain((Mob)this.entity);
    }

    @Override
    public void onUpdate() {
        if (this.boost != null && this.boost.getPassengers().isEmpty() && this.boost.getTicksLived() > 10) {
            this.clear();
        }
        this.brain.getBody().setHurtTime(20);
        if (SettingsManager.getConfig().getBoolean("Mounts." + ((MountType)this.getType()).getConfigName() + ".Stationary")) {
            return;
        }
        float yaw = this.getPlayer().getLocation().getYaw();
        this.brain.getBody().setPitch(this.getPlayer().getLocation().getPitch());
        this.brain.getBody().setYaw(yaw - 180.0f);
        double angleInRadians = Math.toRadians(-yaw);
        double x = Math.sin(angleInRadians);
        double z = Math.cos(angleInRadians);
        Vector v = this.entity.getLocation().getDirection();
        this.brain.getController().naturalMoveTo(x, v.getY(), z, NaturalMoveType.SELF);
    }

    @Override
    protected void removeEntity() {
        super.removeEntity();
        if (this.boost != null) {
            this.boost.remove();
        }
    }

    @Override
    public void onClear() {
        super.onClear();
        if (!this.getPlayer().isOnGround()) {
            FallDamageManager.addNoFall((Entity)this.getPlayer());
        }
    }

    @EventHandler
    public void stopDragonDamage(EntityExplodeEvent event) {
        Entity e = event.getEntity();
        if (e instanceof EnderDragonPart) {
            e = ((EnderDragonPart)e).getParent();
        }
        if (e == this.entity) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity e = event.getDamager();
        if (e instanceof EnderDragonPart) {
            e = ((EnderDragonPart)e).getParent();
        }
        if (e == this.entity) {
            event.setCancelled(true);
        }
    }
}

