/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.UnmovableItemProvider;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class MountHeldItem
extends Mount
implements UnmovableItemProvider {
    private final ItemStack heldItem;
    private final int slot = SettingsManager.getConfig().getInt("Gadget-Slot");
    private final boolean removeWithDrop = SettingsManager.getConfig().getBoolean("Remove-Gadget-With-Drop");

    public MountHeldItem(UltraPlayer ultraPlayer, MountType type, UltraCosmetics ultraCosmetics) {
        super(ultraPlayer, type, ultraCosmetics);
        this.heldItem = new ItemStack(this.getHeldItemMaterial());
        ItemMeta meta = this.heldItem.getItemMeta();
        String loreString = MessageManager.getLegacyMessage(this.getOptionPath("Held-Item-Lore"), new TagResolver.Single[0]);
        meta.setLore(Arrays.asList(loreString.split("\n")));
        this.heldItem.setItemMeta(meta);
        ItemFactory.applyCosmeticMarker(this.heldItem);
    }

    @Override
    public void onEquip() {
        super.onEquip();
        this.getUltraCosmetics().getUnmovableItemListener().addProvider(this);
    }

    @Override
    public void clear() {
        super.clear();
        this.getPlayer().getInventory().setItem(this.slot, null);
        this.getUltraCosmetics().getUnmovableItemListener().removeProvider(this);
    }

    @Override
    public boolean tryEquip() {
        this.getOwner().removeCosmetic(Category.GADGETS);
        this.getOwner().removeCosmetic(Category.MOUNTS);
        ItemStack current = this.getPlayer().getInventory().getItem(this.slot);
        if (current != null && current.getType() != Material.AIR) {
            MessageManager.send((CommandSender)this.getPlayer(), "Must-Remove.Mounts", Placeholder.unparsed("slot", String.valueOf(this.slot + 1)));
            return false;
        }
        this.getPlayer().getInventory().setItem(this.slot, this.heldItem);
        this.getPlayer().getInventory().setHeldItemSlot(this.slot);
        return true;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void handleDrop(PlayerDropItemEvent event) {
        if (this.removeWithDrop) {
            this.clear();
            event.getItemDrop().remove();
        } else {
            event.setCancelled(true);
        }
    }

    @Override
    public boolean itemMatches(ItemStack stack) {
        return stack != null && stack.isSimilar(this.heldItem);
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public void moveItem(int slot, Player player) {
        this.clear();
    }

    @Override
    public void handleInteract(PlayerInteractEvent event) {
        event.setCancelled(true);
    }

    public ItemStack getHeldItem() {
        return this.heldItem.clone();
    }

    public abstract Material getHeldItemMaterial();
}

